#lang typed/racket

(struct: snake ([dir  : Dir]
                [segs : NEPosnList]))
(struct: world ([snake : Snake]
                [food  : Posn]))

(struct: posn ([x : Real]
               [y : Real]))
(struct: posncons ([car : Posn]
                   [cdr : PosnList]))

(define-type Posn posn)
(define-type PosnCons posncons)
(define-type PosnList (U PosnCons Null))
(define-type NEPosnList PosnCons)
(define-type Snake snake)
(define-type Dir (U "up" "down" "left" "right"))

(: posn=? (-> posn posn Boolean))
(define (posn=? p1 p2)
  (and (= (posn-x p1) (posn-x p2))
       (= (posn-y p1) (posn-y p2))))  

(provide
 posn=?
 [struct-out posncons]
 [struct-out posn]
 [struct-out snake]
 [struct-out world])
