#lang typed/racket

(require benchmark-util
         "data-adaptor.rkt")
(require/typed/check "const.rkt"
                     [BOARD-WIDTH Integer]
                     [BOARD-HEIGHT Integer])
(require/typed/check "data.rkt"
                     [posn=? (Posn Posn . -> . Boolean)])

;; Is the snake colliding with any of the walls?
(: snake-wall-collide? : (Snake . -> . Boolean))
(define (snake-wall-collide? snk)
  (head-collide? (posncons-car (snake-segs snk))))

(: head-collide? : (Posn . -> . Boolean))
(define (head-collide? p)
  (or (<= (posn-x p) 0)
      (>= (posn-x p) BOARD-WIDTH)
      (<= (posn-y p) 0)
      (>= (posn-y p) BOARD-HEIGHT)))

(: snake-self-collide? : (Snake . -> . Boolean))
(define (snake-self-collide? snk)
  (segs-self-collide? (posncons-car (snake-segs snk))
                      (posncons-cdr (snake-segs snk))))

(: segs-self-collide? : (Posn PosnList . -> . Boolean))
(define (segs-self-collide? h segs)
  (cond [(empty? segs) #f]
        [else (or (posn=? (posncons-car segs) h)
                  (segs-self-collide? h (posncons-cdr segs)))]))
(provide
 snake-wall-collide?
 snake-self-collide?)
