using System;

public partial class World
{
	private static RacketRandom r;
	
	public static void InitRandom()
	{
		r=new RacketRandom();
	}
	
	public static void Reset()
	{
		r.Reset();
	}
	
	public static World Step(World w)
	{
		if(Eating(w))
		{
			return SnakeEat(w);
		}
		else
		{
			return World.Make(Snake.Slither(GetSnake(w)), GetFood(w));
		}
	}
	
	public static bool Eating(World w)
	{
		return Posn.Eq(GetFood(w), PosnList.Car(Snake.GetSegs(GetSnake(w))));
	}
	
	public static World ChangeDirection(World w, Dir d)
	{
		return World.Make(Snake.ChangeDirection(GetSnake(w),d), GetFood(w));
	}
	
	public static World SnakeEat(World w)
	{
		int i = r.Next(Global.BOARD_WIDTH - 1) + 1;
		int j = r.Next(Global.BOARD_HEIGHT - 1) + 1;
		Posn p =Posn.Make(i,j);
		//p.ToString().Print();
		return World.Make(Snake.Grow(GetSnake(w)), p);
	}
}

public partial class Snake
{
	public static Snake ChangeDirection(Snake s, Dir d)
	{
		return Snake.Make(d, Snake.GetSegs(s));
	}
}