using System;
using System.Diagnostics;
using System.IO;
using System.Collections.Generic;
using System.Linq;


public class MainClass
{
	public static String LARGE_TEST = "snake-hist-large.rktd.input";
	public static String SMALL_TEST = "snake-hist-small.rktd.input";

	public static void Main(string[] args)
	{
		World.InitRandom();
        TimeSpan time=Process.GetCurrentProcess().UserProcessorTime;
		World w =Play(LARGE_TEST);
		Console.WriteLine(w.ToString());
		time = Process.GetCurrentProcess().UserProcessorTime - time;
		Console.WriteLine((((decimal)(time.TotalMilliseconds))/1000).ToString() + " seconds");
	}
	
	public static World Play(String file)
	{
		ActionList raw_hist = Read(file);
		// #ActionList? hist = ActionList.Reverse(raw_hist);
		ActionList hist = raw_hist;
		World w= World.WORLD;
		foreach(int i in Enumerable.Range(0,100))
		{
			w = Replay(World.WORLD, hist);
		}
		return w;
	}
	
	public static World Replay(World w, ActionList hist)
	{
		World.Reset();
		while(true)
		{
			ActionList h = hist;
			if(h==null)
			{
				return w;
			}
			else
			{
				SnakeAction a = ActionList.Car(h);
				if(a is KeySnakeAction)
				{
					w = World.HandleKey(w, (a as KeySnakeAction).Key);
				}
				if(a is TickSnakeAction)
				{
					w = World.Step(w);
				}
				if(a is StopWhenSnakeAction)
				{
					if(World.GameOver(w))
					{
						// #"Game Over".Print();
					}
				}
				hist=ActionList.Cdr(h);
			}
		}
	}
	
	public static ActionList Read(String file)
	{
		FileInfo f=new FileInfo(file);
		if(f.Exists)
		{
			using(StreamReader fr=new StreamReader(f.OpenRead()))
			{
				ActionList l=null;
				while(!fr.EndOfStream)
				{
					String line=fr.ReadLine();
					if(line.StartsWith("K"))
					{
						l=ActionList.Cons(KeySnakeAction.Make(line.Substring(1)), l);
					}
					else if(line.StartsWith("T"))
					{
						l=ActionList.Cons(TickSnakeAction.Instance, l);
					}
					else if(line.StartsWith("S"))
					{
						l=ActionList.Cons(StopWhenSnakeAction.Instance, l);
					}
				}
				return l;
			}
		}
		throw new Exception("File does not exist: "+file);
	}
}

public interface SnakeAction
{
	
}

public class KeySnakeAction : SnakeAction
{
	public String Key;
	private KeySnakeAction(String k)
	{
		Key=k;
	}
	public static KeySnakeAction Make(String k)
	{
		return new KeySnakeAction(k);
	}
}

public class TickSnakeAction : SnakeAction
{
	private TickSnakeAction()
	{
		
	}
	public static TickSnakeAction Instance = new TickSnakeAction();
}

public class StopWhenSnakeAction : SnakeAction
{
	private StopWhenSnakeAction()
	{
		
	}
	public static StopWhenSnakeAction Instance = new StopWhenSnakeAction();
}