using System;

public partial class Snake
{
	public static bool WallCollide(Snake s)
	{
		return HeadCollide(PosnList.Car(GetSegs(s)));
	}
	
	public static bool HeadCollide(Posn p)
	{
		return Posn.GetX(p) <= 0 || Posn.GetX(p) >= Global.BOARD_WIDTH || Posn.GetY(p) <=0 || Posn.GetY(p) >= Global.BOARD_HEIGHT;
	}
	
	public static bool SelfCollide(Snake s)
	{
		return SegsSelfCollide(PosnList.Car(GetSegs(s)), PosnList.Cdr(GetSegs(s)));
	}
	
	public static bool SegsSelfCollide(Posn p, PosnList segs)
	{
		if(segs == null)
		{
			return false;
		}
		else
		{
			if(Posn.Eq(PosnList.Car(segs), p))
			{
				return true;
			}
			else
			{
				return SegsSelfCollide(p, PosnList.Cdr(segs));
			}
		}
	}
}