using System;

interface IStreamThunk
{
	Stream Unfold();
}

class UnfoldPair
{
	public readonly dynamic Head;
	public readonly dynamic Rest;
	
	public UnfoldPair(dynamic hd, dynamic tl)
	{
		Head = hd;
		Rest = tl;
	}
}

class Stream
{
	public readonly dynamic First;
	public readonly dynamic Rest;
	
	public Stream(dynamic first, dynamic rest)
	{
		First=first;
		Rest=rest;
	}
	
	public static UnfoldPair Unfold(dynamic s)
	{
		return new UnfoldPair((dynamic)s.First, (dynamic)s.Rest.Unfold());
	}
	
	public static int Get(dynamic s, int n)
	{
		dynamic ufp = Stream.Unfold(s);
		while((dynamic)n > (dynamic)0)
		{
			ufp = Stream.Unfold((dynamic)ufp.Rest);
			n-=1;
		}
		return ufp.Head;
	}
}