using System;
using System.IO;
using System.Diagnostics;
using System.Threading;

class CountFromThunk : IStreamThunk
{
	private readonly dynamic n;
	
	public CountFromThunk(dynamic start)
	{
		n=start;
	}
	
	public Stream Unfold()
	{
		return MainClass.CountFrom((dynamic)n+(dynamic)1);
	}
}

class SiftThunk : IStreamThunk
{
	private readonly dynamic n;
	private readonly dynamic stream;
	
	public SiftThunk(dynamic siftFor, dynamic rest)
	{
		n=siftFor;
		stream=rest;
	}
	
	public Stream Unfold()
	{
		return MainClass.Sift(n, stream);
	}
}

class SieveThunk : IStreamThunk
{
	private readonly dynamic n;
	private readonly dynamic stream;
	
	public SieveThunk(dynamic siftFor, dynamic rest)
	{
		n=siftFor;
		stream=rest;
	}
	
	public Stream Unfold()
	{
		return MainClass.Sieve((dynamic)MainClass.Sift(n, stream));
	}
}

class MainClass
{
	public static Stream CountFrom(dynamic n)
	{
		return new Stream(n, (dynamic)new CountFromThunk(n));
	}
	
	public static Stream Sift(dynamic n, dynamic s)
	{
		dynamic ufp = Stream.Unfold(s);
		if(ufp.Head % (dynamic)n == (dynamic)0)
		{
			return Sift(n, (dynamic)ufp.Rest); 
		}
		else
		{
			return new Stream((dynamic)ufp.Head, (dynamic)new SiftThunk(n, (dynamic)(ufp.Rest)));
		}
	}
	
	public static Stream Sieve(Stream s)
	{
		dynamic ufp = Stream.Unfold(s);
		return new Stream((dynamic)ufp.Head, (dynamic)new SieveThunk((dynamic)ufp.Head, (dynamic)ufp.Rest));
	}
	
	public static Stream GetPrimes()
	{
		return Sieve((dynamic)CountFrom((dynamic)2));
	}
	
	public static dynamic Nminus1 = 9999;
	
	public static void Main(string[] args)
	{
        dynamic time=Process.GetCurrentProcess().UserProcessorTime;
		Console.WriteLine("The "+(Nminus1+1).ToString()+"th prime number is "+Stream.Get(GetPrimes(),Nminus1).ToString());
		time = Process.GetCurrentProcess().UserProcessorTime - time;
		Console.WriteLine((((decimal)(time.TotalMilliseconds))/1000).ToString() + " seconds");
	}
}