using System;
using System.IO;
using System.Diagnostics;
using System.Threading;

class CountFromThunk : IStreamThunk
{
	private readonly int n;
	
	public CountFromThunk(int start)
	{
		n=start;
	}
	
	public Stream Unfold()
	{
		return MainClass.CountFrom(n+1);
	}
}

class SiftThunk : IStreamThunk
{
	private readonly int n;
	private readonly Stream stream;
	
	public SiftThunk(int siftFor, Stream rest)
	{
		n=siftFor;
		stream=rest;
	}
	
	public Stream Unfold()
	{
		return MainClass.Sift(n, stream);
	}
}

class SieveThunk : IStreamThunk
{
	private readonly int n;
	private readonly Stream stream;
	
	public SieveThunk(int siftFor, Stream rest)
	{
		n=siftFor;
		stream=rest;
	}
	
	public Stream Unfold()
	{
		return MainClass.Sieve(MainClass.Sift(n, stream));
	}
}

class MainClass
{
	public static Stream CountFrom(int n)
	{
		return new Stream(n, new CountFromThunk(n));
	}
	
	public static Stream Sift(int n, Stream s)
	{
		UnfoldPair ufp = Stream.Unfold(s);
		if(ufp.Head % n == 0)
		{
			return Sift(n, ufp.Rest); 
		}
		else
		{
			return new Stream(ufp.Head, new SiftThunk(n, ufp.Rest));
		}
	}
	
	public static Stream Sieve(Stream s)
	{
		UnfoldPair ufp = Stream.Unfold(s);
		return new Stream(ufp.Head, new SieveThunk(ufp.Head, ufp.Rest));
	}
	
	public static Stream GetPrimes()
	{
		return Sieve(CountFrom(2));
	}
	
	public static int Nminus1 = 9999;
	
	public static void Main(string[] args)
	{
        TimeSpan time=Process.GetCurrentProcess().UserProcessorTime;
		Console.WriteLine("The "+(Nminus1+1).ToString()+"th prime number is "+Stream.Get(GetPrimes(),Nminus1).ToString());
		time = Process.GetCurrentProcess().UserProcessorTime - time;
		Console.WriteLine((((decimal)(time.TotalMilliseconds))/1000).ToString() + " seconds");
	}
}