#!/bin/bash

BMNAME="Snake"

echo "Running Benchmark $BMNAME"

mkdir ./NG_snake/fullbackups
mv ./NG_snake/benchmark/*_full.csv ./NG_snake/fullbackups/
./Benchmark.exe -l ng-bash -r NG_snake -n 10 -w --no-parallelization
cp -f ./NG_snake/benchmark/*_full.csv ./ng_snake.csv

mkdir ./racket_snake/fullbackups
mv ./racket_snake/benchmark/*_full.csv ./racket_snake/fullbackups/
./Benchmark.exe -l racket -r racket_snake -n 10 -w --no-parallelization
cp -f ./racket_snake/benchmark/*_full.csv ./racket_snake.csv

mkdir ./racket_snake_new/fullbackups
mv ./racket_snake_new/benchmark/*_full.csv ./racket_snake_new/fullbackups/
./Benchmark.exe -l racket -r racket_snake_new -n 10 -w --no-parallelization
cp -f ./racket_snake_new/benchmark/*_full.csv ./racket_snake_new.csv

python3 scatterplot.py snake.png ng_snake.csv Nom racket_snake.csv "Racket" racket_snake_new.csv "Racket*"

echo "Benchmark $BMNAME complete"
