using System;

public partial class World
{
	private static dynamic r;
	
	public static void InitRandom()
	{
		r=new RacketRandom();
	}
	
	public static void Reset()
	{
		r.Reset();
	}
	
	public static dynamic Step(dynamic w)
	{
		if(Eating(w))
		{
			return SnakeEat(w);
		}
		else
		{
			return World.Make((dynamic)Snake.Slither((dynamic)GetSnake(w)), (dynamic)GetFood(w));
		}
	}
	
	public static dynamic Eating(dynamic w)
	{
		return Posn.Eq((dynamic)GetFood(w), (dynamic)PosnList.Car((dynamic)Snake.GetSegs((dynamic)GetSnake(w))));
	}
	
	public static dynamic ChangeDirection(dynamic w, dynamic d)
	{
		return World.Make((dynamic)Snake.ChangeDirection((dynamic)GetSnake(w),d), (dynamic)GetFood(w));
	}
	
	public static dynamic SnakeEat(dynamic w)
	{
		dynamic i = r.Next((dynamic)Global.BOARD_WIDTH - (dynamic)1) + (dynamic)1;
		dynamic j = r.Next((dynamic)Global.BOARD_HEIGHT - (dynamic)1) + (dynamic)1;
		dynamic p =Posn.Make(i,j);
		//p.ToString().Print();
		return World.Make((dynamic)Snake.Grow((dynamic)GetSnake(w)), p);
	}
}

public partial class Snake
{
	public static dynamic ChangeDirection(dynamic s, dynamic d)
	{
		return Snake.Make(d, (dynamic)Snake.GetSegs(s));
	}
}