using System;
using System.Diagnostics;
using System.IO;
using System.Collections.Generic;
using System.Linq;


public class MainClass
{
	public static dynamic LARGE_TEST = "snake-hist-large.rktd.input";
	public static dynamic SMALL_TEST = "snake-hist-small.rktd.input";

	public static void Main(string[] args)
	{
		World.InitRandom();
        dynamic time=Process.GetCurrentProcess().UserProcessorTime;
		dynamic w =Play(LARGE_TEST);
		Console.WriteLine(w.ToString());
		time = Process.GetCurrentProcess().UserProcessorTime - time;
		Console.WriteLine((((decimal)(time.TotalMilliseconds))/1000).ToString() + " seconds");
	}
	
	public static dynamic Play(dynamic file)
	{
		dynamic raw_hist = Read(file);
		// #ActionList? hist = ActionList.Reverse(raw_hist);
		dynamic hist = raw_hist;
		dynamic w= World.WORLD;
		foreach(dynamic i in Enumerable.Range(0,100))
		{
			w = Replay(World.WORLD, hist);
		}
		return w;
	}
	
	public static dynamic Replay(dynamic w, dynamic hist)
	{
		World.Reset();
		while(true)
		{
			dynamic h = hist;
			if(h==null)
			{
				return w;
			}
			else
			{
				dynamic a = ActionList.Car(h);
				if(a is KeySnakeAction)
				{
					w = World.HandleKey(w, a.Key);
				}
				if(a is TickSnakeAction)
				{
					w = World.Step(w);
				}
				if(a is StopWhenSnakeAction)
				{
					if(World.GameOver(w))
					{
						// #"Game Over".Print();
					}
				}
				hist=(dynamic)ActionList.Cdr(h);
			}
		}
	}
	
	public static dynamic Read(dynamic file)
	{
		dynamic f=new FileInfo(file);
		if(f.Exists)
		{
			using(dynamic fr=new StreamReader(f.OpenRead()))
			{
				dynamic l=null;
				while(!fr.EndOfStream)
				{
					dynamic line=fr.ReadLine();
					if(line.StartsWith("K"))
					{
						l=ActionList.Cons((dynamic)KeySnakeAction.Make(line.Substring(1)), l);
					}
					else if(line.StartsWith("T"))
					{
						l=ActionList.Cons((dynamic)TickSnakeAction.Instance, l);
					}
					else if(line.StartsWith("S"))
					{
						l=ActionList.Cons((dynamic)StopWhenSnakeAction.Instance, l);
					}
				}
				return l;
			}
		}
		throw new Exception("File does not exist: "+file);
	}
}

public interface SnakeAction
{
	
}

public class KeySnakeAction : SnakeAction
{
	public dynamic Key;
	private KeySnakeAction(dynamic k)
	{
		Key=k;
	}
	public static KeySnakeAction Make(dynamic k)
	{
		return new KeySnakeAction(k);
	}
}

public class TickSnakeAction : SnakeAction
{
	private TickSnakeAction()
	{
		
	}
	public static TickSnakeAction Instance = new TickSnakeAction();
}

public class StopWhenSnakeAction : SnakeAction
{
	private StopWhenSnakeAction()
	{
		
	}
	public static StopWhenSnakeAction Instance = new StopWhenSnakeAction();
}