using System;

public partial class Snake
{
	private readonly dynamic Direction;
	private readonly dynamic Segs;
	
	private Snake(dynamic d, dynamic s)
	{
		Direction=d;
		Segs=s;
	}
	
	public static dynamic Make(dynamic d, dynamic s)
	{
		return new Snake(d,s);
	}
	
	public static dynamic GetDir(Snake s)
	{
		return s.Direction;
	}
	
	public static dynamic GetSegs(Snake s)
	{
		return s.Segs;
	}
	
	public override string ToString()
	{
		return PosnList.Car(Segs).ToString();
	}
}

public partial class World
{
	private readonly dynamic SnakeObj;
	private readonly dynamic Food;
	
	private World(dynamic s, dynamic f)
	{
		SnakeObj=s;
		Food=f;
	}
	
	public static dynamic Make(dynamic s, dynamic f)
	{
		return new World(s,f);
	}
	
	public static dynamic GetSnake(World w)
	{
		return w.SnakeObj;
	}
	
	public static dynamic GetFood(World w)
	{
		return w.Food;
	}
	
	public override string ToString()
	{
		return Food.ToString()+"; "+SnakeObj.ToString();
	}
}

public partial class Posn
{
	private readonly dynamic X;
	private readonly dynamic Y;
	
	private Posn(dynamic x, dynamic y)
	{
		X=x;
		Y=y;
	}
	
	public static dynamic Make(dynamic x, dynamic y)
	{
		return new Posn(x,y);
	}
	
	public static dynamic GetX(Posn p)
	{
		return p.X;
	}
	
	public static dynamic GetY(Posn p)
	{
		return p.Y;
	}
	
	public static dynamic Eq(dynamic l, dynamic r)
	{
		return l.X == r.X && l.Y == r.Y;
	}
	
	public override String ToString()
	{
		return "("+X.ToString()+", "+Y.ToString()+")";
	}
}

public enum Dir
{
	Up,
	Down,
	Left,
	Right
}

public class ActionList
{
	private readonly dynamic Head;
	private readonly dynamic Tail;
	
	private ActionList(dynamic head, dynamic tl)
	{
		Head=head;
		Tail=tl;
	}
	
	public static ActionList Cons(dynamic hd, dynamic tl)
	{
		return new ActionList(hd,tl);
	}
	
	public static SnakeAction Car(ActionList l)
	{
		return l.Head;
	}
	
	public static ActionList Cdr(ActionList l)
	{
		return l.Tail;
	}
}

public class PosnList
{
	private readonly dynamic Head;
	private readonly dynamic Tail;
	
	private PosnList(dynamic hd, dynamic tl)
	{
		Head=hd;
		Tail=tl;
	}
	
	public static dynamic Cons(dynamic hd, dynamic tl)
	{
		return new PosnList(hd,tl);
	}
	
	public static dynamic Car(PosnList l)
	{
		return l.Head;
	}
	
	public static dynamic Cdr(PosnList l)
	{
		return l.Tail;
	}
}