﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

    interface IRandom
    {
        void Reset();
        int Next(int max);
    }

    class RacketRandom : IRandom
    {
        private static int[] Nums ={19,
  18,
  26,
  7,
  2,
  14,
  24,
  3,
  7,
  4,
  17,
  15,
  28,
  1,
  29,
  11,
  8,
  18,
  24,
  18,
  0,
  7,
  18,
  0,
  29,
  13,
  23,
  9,
  29,
  16,
  9,
  19,
  19,
  2,
  28,
  13,
  5,
  16,
  15,
  10,
  10,
  2,
  0,
  16,
  5,
  7,
  17,
  8,
  20,
  11,
  6,
  13,
  7,
  3,
  0,
  12,
  29,
  3,
  1,
  9,
  3,
  2,
  23,
  11,
  24,
  11,
  18,
  9,
  7,
  14,
  11,
  17,
  18,
  14,
  28,
  12,
  23,
  3,
  10,
  3,
  2,
  17,
  27,
  3,
  27,
  15,
  14,
  1,
  13,
  15,
  21,
  8,
  2,
  1,
  26,
  10,
  7,
  12,
  27,
  13,
  27,
  17,
  7,
  0,
  12,
  13,
  13,
  17,
  10,
  16,
  23,
  12,
  26,
  4,
  21,
  4,
  28,
  1,
  23,
  14,
  7,
  12,
  3,
  18,
  9,
  16,
  17,
  0,
  12,
  13,
  19,
  16,
  1,
  14,
  13,
  19,
  20,
  1,
  10,
  18,
  6,
  16,
  18,
  3,
  0,
  8,
  16,
  12,
  17,
  5,
  0,
  14,
  10,
  14,
  28,
  18,
  13,
  14,
  12,
  6,
  7,
  5,
  25,
  5,
  23,
  18,
  11,
  15,
  3,
  3,
  24,
  15,
  17,
  19,
  18,
  10,
  0,
  11,
  12,
  10,
  5,
  1,
  16,
  2,
  9,
  17,
  11,
  19,
  12,
  12,
  23,
  6,
  21,
  9,
  28,
  6,
  25,
  3,
  10,
  17};

        private Queue<int> nums;
        public RacketRandom()
        {
            Reset();
        }
        public void Reset()
        {
            nums = new Queue<int>(Nums);
        }

        public int Next(int max)
        {
            return nums.Dequeue() % max;
        }
    }

    public class CSharpRandom : IRandom
    {
        private Random r;
        public CSharpRandom()
        {
            Reset();
        }

        public void Reset()
        {
            r = new Random(1324);
        }

        public int Next(int max)
        {
            return r.Next(max);
        }
    }
