using System;

public partial class Snake
{
	private readonly Dir Direction;
	private readonly PosnList Segs;
	
	private Snake(Dir d, PosnList s)
	{
		Direction=d;
		Segs=s;
	}
	
	public static Snake Make(Dir d, PosnList s)
	{
		return new Snake(d,s);
	}
	
	public static Dir GetDir(Snake s)
	{
		return s.Direction;
	}
	
	public static PosnList GetSegs(Snake s)
	{
		return s.Segs;
	}
	
	public override string ToString()
	{
		return PosnList.Car(Segs).ToString();
	}
}

public partial class World
{
	private readonly Snake SnakeObj;
	private readonly Posn Food;
	
	private World(Snake s, Posn f)
	{
		SnakeObj=s;
		Food=f;
	}
	
	public static World Make(Snake s, Posn f)
	{
		return new World(s,f);
	}
	
	public static Snake GetSnake(World w)
	{
		return w.SnakeObj;
	}
	
	public static Posn GetFood(World w)
	{
		return w.Food;
	}
	
	public override string ToString()
	{
		return Food.ToString()+"; "+SnakeObj.ToString();
	}
}

public partial class Posn
{
	private readonly int X;
	private readonly int Y;
	
	private Posn(int x, int y)
	{
		X=x;
		Y=y;
	}
	
	public static Posn Make(int x, int y)
	{
		return new Posn(x,y);
	}
	
	public static int GetX(Posn p)
	{
		return p.X;
	}
	
	public static int GetY(Posn p)
	{
		return p.Y;
	}
	
	public static bool Eq(Posn l, Posn r)
	{
		return l.X == r.X && l.Y == r.Y;
	}
	
	public override String ToString()
	{
		return "("+X.ToString()+", "+Y.ToString()+")";
	}
}

public enum Dir
{
	Up,
	Down,
	Left,
	Right
}

public class ActionList
{
	private readonly SnakeAction Head;
	private readonly ActionList Tail;
	
	private ActionList(SnakeAction head, ActionList tl)
	{
		Head=head;
		Tail=tl;
	}
	
	public static ActionList Cons(SnakeAction hd, ActionList tl)
	{
		return new ActionList(hd,tl);
	}
	
	public static SnakeAction Car(ActionList l)
	{
		return l.Head;
	}
	
	public static ActionList Cdr(ActionList l)
	{
		return l.Tail;
	}
}

public class PosnList
{
	private readonly Posn Head;
	private readonly PosnList Tail;
	
	private PosnList(Posn hd, PosnList tl)
	{
		Head=hd;
		Tail=tl;
	}
	
	public static PosnList Cons(Posn hd, PosnList tl)
	{
		return new PosnList(hd,tl);
	}
	
	public static Posn Car(PosnList l)
	{
		return l.Head;
	}
	
	public static PosnList Cdr(PosnList l)
	{
		return l.Tail;
	}
}