using System;

interface IStreamThunk
{
	Stream Unfold();
}

class UnfoldPair
{
	public readonly int Head;
	public readonly Stream Rest;
	
	public UnfoldPair(int hd, Stream tl)
	{
		Head = hd;
		Rest = tl;
	}
}

class Stream
{
	public readonly int First;
	public readonly IStreamThunk Rest;
	
	public Stream(int first, IStreamThunk rest)
	{
		First=first;
		Rest=rest;
	}
	
	public static UnfoldPair Unfold(Stream s)
	{
		return new UnfoldPair(s.First, s.Rest.Unfold());
	}
	
	public static int Get(Stream s, int n)
	{
		UnfoldPair ufp = Stream.Unfold(s);
		while(n > 0)
		{
			ufp = Stream.Unfold(ufp.Rest);
			n-=1;
		}
		return ufp.Head;
	}
}