(** * Introduction : Introduction *)
(** * Mechanically Verified Proofs from "Empowering Union and Intersection Types with Integrated Subtyping"*)
(** ** Preface
    This is not the artifact that was evaluated during the OOPSLA 2018 Artifact Evaluation process, rather it is an improvement on that artifact.
    For archival purposes, the outdated artifact that was evaluated is provided in #<a href="outdated_artifact.zip">#outdated_artifact.zip#</a>#.
    However, the outdated artifact does not directly support the claims stated in the paper, and the section of the paper that discussed what claims it did support has been removed, so we strongly discourage referencing the outdated artifact.
    The artifact presented here, although it was not evaluated, has been developed to the same or higher quality than the one that was, and was made to directly support the claims in the paper.
*)
(** ** Introduction#&nbsp;#*)
(** This document gives an overview of the Coq formalization we have created for our paper.
    It formalizes every requirement and claim in Sections 3 - 5.
    It is meant to be read along with the paper and largely tries to follow the flow of the paper exactly, with the exception that for engineering reasons, the requirements of each section are all stated together, followed by the Lemmas and Theorems of that section.

    In case you are not familiar with Coq's module system: we implemented this formalization as a library for people to use.
    A "Module Type" specifies a signature that a user needs to implement; "Parameter"s within that module type are the specific things a user needs to provide/proof.
    Once a user instantiated a module type in a module of their own, they can use that to instantiate our "Module"s, which provide the extended systems/proofs based on the user's input.

    This file contains only the signatures of the various components of our proof, but for each file (.v), there is a link at the beginning of the section corresponding to that file that leads to the coqdoc for the full file including the actual proof code. 
    The .v-files themselves are also included and can be used to verify the proofs in Coq. 
    The files should be compiled in the order in which they appear in this file.

    All of this was generated using coqdoc, whose approach to links in the face of modules is not the most helpful one.
    However, other syntax highlighting features depend on the same information as link generation, so the code should still be a lot more readable than without links. 
    We made sure that links in standard HTML rendering (blue underlined) lead to where they should, and most of the links should get you at least closer to where the definition you wanted to was.

    We prove an example of how to instantiate the module types of Sections 3 and 4 in #<a href="Example.html">Example.v</a>#.

    *** Outline
    The following outline of the proofs shows the items that correspond to something in the paper:
    - #<a href="##vfile_sec3req">Section 3: Formalizing Traditional Union and Intersection Subtyping</a>#
      - Literals ([Lit]; in many cases an (implicit) parameter)
      - Types (#<tt>Notation </tt>#[T]#<tt> := </tt>#[UIType Lit])
      - Declarative Subtyping with Assumptions ([dsuba])
      - Reductive Subtyping with Assumptions ([rsubam]; see explanation at definition)
      - Declarative Literal Subtyping Rules ([DRule] and [DPremise])
      - Declarative Subtyping ([dsub] based on [dsuba] and [dsubf])
      - Reductive Literal Subtyping Rules ([RRule] and [RPremise])
      - Reductive Subtyping ([rsub] based on [uisub], [lsub], and [rsubf])
      - Requirements
        - Requirement 1: Syntax-Directedness ([SyntaxDirectedness_Rules] and [SyntaxDirectedness_Premises])
        - Requirement 2: Well-Foundedness ([m], [M], [mlt], [mltwf], [m_ui_l], [m_ui_r], and [m_lit])
        - Requirement 3: Literal Reflexivity ([LiteralReflexivity])
        - Requirement 4: R-to-D Literal Conversion ([RRuleToDProof])
        - Requirement 5: D-to-R Literal Conversion ([DRuleToRProof])
        - Requirement 6: Literal Transitivity ([LiteralTransitivity])
      - Decidability of Declarative Subtyping Theorem ([DecidabilityOfDeclarativeSubtyping])
    - #<a href="##vfile_sec4req">Section 4: Empowering Unions and Intersections</a>#
      - Integrator #DNF<sub>c</sub># ([Integrate])
      - Integrated Predicate #dnf<sub>&phi;</sub>/dnf<sub>&phi;</sub><sup>&cap;</sup># ([Integrated] and [Integrated_int])
      - Extension Axioms ([extension])
      - Extended Subtyping ([esub])
      - Intersector# (&sqcap;)# ([intersect])
      - Intersected Predicate# (&phi;)# ([intersected])
      - #<a href="##vfile_sec4req">Requirements</a>#
        - Requirement 7: Intersector Completeness ([IntersectorCompleteness])
        - Requirement 8: Intersector Soundness ([IntersectorSoundness])
        - Requirement 9: Measure Preservation ([MeasurePreservation])
        - Requirement 10: Literal Dereliction ([LiteralDereliction])
        - Requirement 11: Intersector Integrated ([IntersectorIntegrated])
        - Requirement 12: Literal Promotion ([LiteralPromotion])
      - #<a href="##vfile_sec4proofs">Proofs</a>#
        - Lemma 1: Integrated Soundness ([IntegratedSoundness])
        - Lemma 2: Integrated Decidability ([IntegratedDecidability])
        - Lemma 3: Dereliction ([Dereliction])
        - Lemma 4: Integrator Integrated ([IntegratorIntegrated])
        - Lemma 5: Promotion ([Promotion])
        - Lemma 6: Integrated Monotonicity ([IntegratedMonotonicity])
        - Lemma 7: Integrated Assumptions ([IntegratedAssumptions])
        - Lemma 8: Integrated Promotion ([IntegratedPromotion])
        - Lemma 9: Integrated Reflexivity ([IntegratedReflexivity])
        - Lemma 10: D-to-I Literal Conversion ([DeclarativeToIntegratedLiteralConversion])
        - Lemma 11: Integrated Transitivity ([IntegratedTransitivity])
        - Lemma 12: Integrated Completeness ([IntegratedCompleteness])
        - Decidability of Extended Subtyping Theorem ([DecidabilityOfExtendedSubtyping] and [OptimizedDecidabilityOfExtendedSubtyping])
    - #<a href="##vfile_sec5">Section 5: Composability</a>#
      - Requirement 13: Intersected Preservation ([IntersectedPreservation])
      - Intersector Composability Theorem (Module [Composition])

    *** Paper Concept Index
    The following table gives an outline of the parts of our paper and where to find their corresponding counterpart in this formalization:
    #<table class="indextable">
     <tr><th>Concept from Paper</th><th>Corresponding Definitions/Lemmas/Theorems</th><th>Comment</th></tr>
     <tr><td>Literals</td><td>#[Lit]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td>Also an implicit parameter in many global definitions</td></tr>
     <tr><td>Types</td><td><tt>Notation </tt>#[T]#<tt> := </tt>#[UIType Lit]# defined almost everywhere</td><td>#[UIType]# is defined in <a href="##vfile_sec3req">Section3_Requirements.v</a></td></tr>
     <tr><td>Declarative Literal Subtyping Rules</td><td>#[DRule]# and #[DPremise]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td></td></tr>
     <tr><td>Declarative Subtyping</td><td>#[dsub]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td>Based on #[dsuba]# and #[dsubf]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td></tr>
     <tr><td>Reductive Literal Subtyping Rules</td><td>#[RRule]# and #[RPremise]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td></td></tr>
     <tr><td>Reductive Subtyping</td><td>#[rsub]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td>Based on #[uisub]#, #[lsub]#, and #[rsubf]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td></tr>
     <tr><td>Requirement 1: Syntax-Directedness</td><td>#[SyntaxDirectedness_Rules]# and #[SyntaxDirectedness_Premises]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td></td></tr>
     <tr><td>Requirement 2: Well-Foundedness</td><td>#[m]#, #[M]#, #[mlt]#, #[mltwf]#, #[m_ui_l]#, #[m_ui_r]#, and #[m_lit]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td></td></tr>
     <tr><td>Requirement 3: Literal Reflexivity</td><td>#[LiteralReflexivity]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td></td></tr>
     <tr><td>Declarative Subtyping with Assumptions</td><td>#[dsuba]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td></td></tr>
     <tr><td>Reductive Subtyping with Assumptions</td><td>#[rsubam]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td>Also includes Monotonicity, which makes the proof stronger than in the paper (see explanation at definition)</td></tr>
     <tr><td>Requirement 4: R-to-D Literal Conversion</td><td>#[RRuleToDProof]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td></td></tr>
     <tr><td>Requirement 5: D-to-R Literal Conversion</td><td>#[DRuleToRProof]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td></td></tr>
     <tr><td>Requirement 6: Literal Transitivity</td><td>#[LiteralTransitivity]# in <a href="##vfile_sec3req">Section3_Requirements.v</a></td><td></td></tr>
     <tr><td>Decidability of Declarative Subtyping Theorem</td><td>#[DecidabilityOfDeclarativeSubtyping]# in <a href="##vfile_sec3proofs">Section3_Proofs.v</a></td><td></td></tr>
     <tr><td>Extension Axioms</td><td>#[extension]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Extended Subtyping</td><td>#[esub]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td>Based on #[dsubda]# and #[extension]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td></tr>
     <tr><td>Integrator (DNF<sub>c</sub>)</td><td>#[Integrate]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Intersector (&sqcap;)</td><td>#[intersect]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Requirement 7: Intersector Completeness</td><td>#[IntersectorCompleteness]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Requirement 8: Intersector Soundness</td><td>#[IntersectorSoundness]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Lemma 1: Integrated Soundness</td><td>#[IntegratedSoundness]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Requirement 9: Measure Preservation</td><td>#[MeasurePreservation]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Lemma 2: Integrated Decidability</td><td>#[IntegratedDecidability]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Requirement 10: Literal Dereliction</td><td>#[LiteralDereliction]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Lemma 3: Dereliction</td><td>#[Dereliction]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Intersected Predicate (&phi;)</td><td>#[intersected]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Integrated Predicate (dnf<sub>&phi;</sub>/dnf<sub>&phi;</sub><sup>&cap;</sup>)</td><td>#[Integrated]# and #[Integrated_int]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Requirement 11: Intersector Integrated</td><td>#[IntersectorIntegrated]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Lemma 4: Integrator Integrated</td><td>#[IntegratorIntegrated]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Requirement 12: Literal Promotion</td><td>#[LiteralPromotion]# in <a href="##vfile_sec4req">Section4_Requirements.v</a></td><td></td></tr>
     <tr><td>Lemma 5: Promotion</td><td>#[Promotion]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Lemma 6: Integrated Monotonicity</td><td>#[IntegratedMonotonicity]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td rowspan="2">Actually mostly proved together in #[integrated_assumptions']# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td></tr>
     <tr><td>Lemma 7: Integrated Assumptions</td><td>#[IntegratedAssumptions]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td></tr>
     <tr><td>Lemma 8: Integrated Promotion</td><td>#[IntegratedPromotion]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Lemma 9: Integrated Reflexivity</td><td>#[IntegratedReflexivity]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Lemma 10: D-to-I Literal Conversion</td><td>#[DeclarativeToIntegratedLiteralConversion]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Lemma 11: Integrated Transitivity</td><td>#[IntegratedTransitivity]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Lemma 12: Integrated Completeness</td><td>#[IntegratedCompleteness]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Decidability of Extended Subtyping Theorem</td><td>#[DecidabilityOfExtendedSubtyping]# and #[OptimizedDecidabilityOfExtendedSubtyping]# in <a href="##vfile_sec4proofs">Section4_Proofs.v</a></td><td></td></tr>
     <tr><td>Requirement 13: Intersected Preservation</td><td>#[IntersectedPreservation]# in <a href="##vfile_sec5">Section5.v</a></td><td></td></tr>
     <tr><td>Intersector Composability Theorem</td><td>Module #[Composition]# in <a href="##vfile_sec5">Section5.v</a></td><td>Defines its #[intersect]# and #[extension]# as described in the paper and satisfies the #[Intersector]# module type and hence all the Lemmas and Theorems above.</td></tr>
    </table>#
*)