(** * Introduction : Introduction *)
(** * Proof of the more general integration process*)
(** ** Introduction#&nbsp;#*)
(** This #document# gives an overview of the Coq formalization we have created for our more general framework that
    handles Integrated Subtyping for general type systems, not just those with union and intersection types, as discussed
    in section 7 of the paper.

    In case you are not familiar with Coq's module system: we implemented this formalization as
    a library for people to use. A "Module Type" specifies a signature that a user needs to implement; "Parameter"s within
    that module type are the specific things a user needs to provide/proof. Once a user instantiated a module type in a module
    of their own, they can use that to instantiate our "Module"s, which provide the extended systems/proofs based on the user's input.

    This file contains only the signatures of the various components of our proof, but for each file (.v), there is a link at the beginning
    of the section corresponding to that file that leads to the coqdoc for the full file including the actual proof code. The .v-files
    themselves are also included and can be used to verify the proofs in Coq. The files should be compiled in the order in which they appear
    in this file.

    The following table gives an outline of the parts of our paper and where to find their corresponding
    counterpart in this formalization:
    #<table class="indextable">
     <tr><th>Concept from Paper</th><th>Corresponding Proof Part</th><th>Comment</th></tr>
     <tr><td>Literals & Types</td><td><tt>Typ.T</tt> in <a href="##vfile_common">Common.v</a></td><td>Generalized to arbitrary types, all user-provided</td></tr>
     <tr><td>User-Defined Subtyping Rules</td><td><tt>Rules.Con, Rules.Req, Rules.Ass</tt> in <a href="##vfile_common">Common.v</a></td><td></td></tr>
     <tr><td>Declarative Subtyping Rules</td><td><tt>Traditional.TransRefl.TRCon</tt> etc. in <a href="##vfile_tradition">Tradition.v</a></td><td>in our original formalization, we used the term "Traditional" instead of "Declarative"</td></tr>
     <tr><td>Reductive Subtyping Rules</td><td>see User-Defined Typing Rules</td><td>While Declarative Rules add reflexivity and transitivity, Reductive Rules are all user-supplied in this more general framework</td></tr>
     <tr><td>Requirement 1: Syntax-Directedness</td><td><tt>DecidableRules.finite_con</tt> in <a href="##vfile_decide">Decide.v</a></td><td></td></tr>
     <tr><td>Requirement 2: Well-Foundedness</td><td><tt>DecidableRules.wf</tt> in <a href="##vfile_decide">Decide.v</a></td><td></td></tr>
     <tr><td>Requirement 3: Literal Reflexivity</td><td><tt>DecidableRules.refl</tt> in <a href="##vfile_decide">Decide.v</a></td><td>Since everything is a literal/type, this captures all types</td></tr>
     <tr><td>Subtyping Rules with Assumptions</td><td><tt>ProofPV.ProofPV</tt> etc. in <a href="##vfile_common">Common.v</a></td><td></td></tr>
     <tr><td>Requirement 4: R-to-D Literal Conversion</td><td><tt>Converter.decidable_traditional_R</tt> in <a href="##vfile_convert">Convert.v</a></td><td></td></tr>
     <tr><td>Requirement 5: D-to-R Literal Conversion</td><td><tt>Converter.traditional_decidable_R</tt> in <a href="##vfile_convert">Convert.v</a></td><td></td></tr>
     <tr><td>Requirement 6: Literal Transitivity</td><td><tt>DecidableRules.Red</tt> in <a href="##vfile_decide">Decide.v</a></td><td>See also <tt>Reduction.Reduction</tt> in <a href="##vfile_common">Common.v</a></td></tr>
     <tr><td>Decidability of Declarative Subtyping Theorem</td><td><tt>Conversion.decidable_traditional</tt> and <tt>Conversion.traditional_decidable</tt> in <a href="##vfile_convert">Convert.v</a></td><td>Together with <tt>Decider.decider</tt> in <a href="##vfile_decide">Decide.v</a></td></tr>
     <tr><td>Extended Subtyping</td><td><tt>Extension.Con</tt> and <tt>ExtendedRules.ECon</tt> etc. in <a href="##vfile_extend">Extend.v</a></td><td></td></tr>
     <tr><td>Intersector/Integrator</td><td><tt>Comonad.i</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td>Since everything is a literal/type, there is no distinction between intersector and integrator</td></tr>
     <tr><td>Requirement 7: Intersector Completeness</td><td><tt>Equivocator.iextended</tt> in <a href="##vfile_equate">Equate.v</a></td><td></td></tr>
     <tr><td>Requirement 8: Intersector Soundness</td><td><tt>Equivocator.unit</tt> in <a href="##vfile_equate">Equate.v</a></td><td></td></tr>
     <tr><td>Lemma 1: Integrated Soundness</td><td><tt>Equivalence.ipreprocessing_extended</tt> in <a href="##vfile_equate">Equate.v</a></td><td></td></tr>
     <tr><td>Requirement 9: Measure Preservation</td><td><tt>WellFoundedComonad.i_wf</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td>Requires full well-foundedness proof instead of measure preservation</td></tr>
     <tr><td>Lemma 2: Integrated Decidability</td><td><tt>Decider.decider</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td></td></tr>
     <tr><td>Requirement 10: Literal Dereliction</td><td><tt>Comonad.counit</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td></td></tr>
     <tr><td>Lemma 3: Dereliction</td><td><tt>Comonad.counit</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td>Same as Requirement 10 due to missing type/literal distinction</td></tr>
     <tr><td>Intersected Predicate</td><td><tt>Comonad.Preprocessed</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td></td></tr>
     <tr><td>Requirement 11: Intersector Integrated</td><td><tt>Comonad.i_Preprocessed</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td></td></tr>
     <tr><td>Lemma 4: Integrator Integrated</td><td><tt>Comonad.i_Preprocessed</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td>Same as Requirement 11 due to missing type/literal distinction</td></tr>
     <tr><td>Requirement 12: Literal Promotion</td><td><tt>Comonad.i_promote_R</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td></td></tr>
     <tr><td>Lemma 5: Promotion</td><td><tt>Preprocessing.dpromote'</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td></td></tr>
     <tr><td>Lemma 6: Integrated Monotonicity</td><td>-</td><td rowspan="2">Helper Lemmas, established in various different forms in <a href="##vfile_preprocess">Preprocess.v</a></td></tr>
     <tr><td>Lemma 7: Integrated Assumptions</td><td>-</td></tr>
     <tr><td>Lemma 8: Integrated Promotion</td><td><tt>Preprocessing.promote</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td></td></tr>
     <tr><td>Lemma 9: Integrated Reflexivity</td><td><tt>Comonad.derelict</tt> and <tt>Comonad.refl</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td></td></tr>
     <tr><td>Lemma 10: D-to-I Literal Conversion</td><td><tt>Equivalence.iadmitst</tt> in <a href="##vfile_equate">Equate.v</a></td><td></td></tr>
     <tr><td>Lemma 11: Integrated Transitivity</td><td><tt>Preprocessing.itrans</tt> in <a href="##vfile_preprocess">Preprocess.v</a></td><td></td></tr>
     <tr><td>Lemma 12: Integrated Completeness</td><td><tt>Equivalence.extended_ipreprocessing</tt> in <a href="##vfile_equate">Equate.v</a></td><td></td></tr>
     <tr><td>Decidability of Extended Subtyping Theorem</td><td><tt>Equivalence.decider</tt> in <a href="##vfile_equate">Equate.v</a></td><td></td></tr>
    </table>#

    All of this was generated using coqdoc, whose approach to links in the face of modules is not the most helpful one.
    However, other syntax highlighting features depend on the same information as link generation, so the code should
    still be a lot more readable than without links. We made sure that links in standard HTML rendering (blue underlined) lead to where they
    should, and most of the links should get you at least closer to where the definition you wanted to was.
*)