#!/usr/bin/python

###############################################################################
#   File: cpd.py
#
#   This file is part of prunner
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
################################################################################
import sys

import cherrypy
from cherrypy.process import plugins, servers

import ClusterPage
from PRunner import *

appconfig = { '/' : { 'tools.staticdir.root': ClusterPage.CURRENT_DIR + '/data' },
              '/css': { 'tools.staticdir.on': True,
                        'tools.staticdir.dir': 'css' },
              '/img': { 'tools.staticdir.on': True,
                        'tools.staticdir.dir': 'img' },
              '/manage' : { 'tools.digest_auth.on': True,
                            'tools.digest_auth.realm': 'Cluster Management Page',
                            'tools.digest_auth.users': None}
            }
                    
def start(prunner, configfiles=None, daemonize=False, environment=None, pidfile=None, imports=None):
    """Subscribe all engine plugins and start the engine."""
    sys.path = [''] + sys.path
    for i in imports or []:
        exec "import %s" % i
    
    for c in configfiles or []:
        cherrypy.config.update(c)
    
    engine = cherrypy.engine
    
    if environment is not None:
        cherrypy.config.update({'environment': environment})
    
    appconfig['/manage']['tools.digest_auth.users'] = prunner.clusters.auth
    cherrypy.tree.mount(ClusterPage.Root(prunner), '/', appconfig)

    # Only daemonize if asked to.
    if daemonize:
        # Don't print anything to stdout/sterr.
        cherrypy.config.update({'log.screen': False})
        plugins.Daemonizer(engine).subscribe()
    
    if pidfile:
        plugins.PIDFile(engine, pidfile).subscribe()
    
    if hasattr(engine, "signal_handler"):
        engine.signal_handler.subscribe()
    if hasattr(engine, "console_control_handler"):
        engine.console_control_handler.subscribe()
    
    # Always start the engine; this will start all other services
    try:
        engine.start()
    except:
        # Assume the error has been logged already via bus.log.
        sys.exit(1)
    else:
        engine.block()


if __name__ == '__main__':
    from optparse import OptionParser
    
    p = OptionParser()
    p.add_option('-c', '--config', action="append", dest='config',
                 help="specify config file(s)")
    p.add_option('-d', action="store_true", dest='daemonize',
                 help="run the server as a daemon")
    p.add_option('-e', '--environment', dest='environment', default=None,
                 help="apply the given config environment")
    p.add_option('-i', '--import', action="append", dest='imports',
                 help="specify modules to import")
    p.add_option('-p', '--pidfile', dest='pidfile', default=None,
                 help="store the process id in the given file")
    p.add_option('-r', '--prconfig', dest='prconfig', default=None,
                 help="configure for parallel runner")
    p.add_option('-f', '--cmdfile', dest='cmdfile', default=None,
                 help="command file")
    options, args = p.parse_args()
    
    start(ParallelRunner.ParallelRunner(options.prconfig, options.cmdfile),
          options.config, options.daemonize, options.environment, 
          options.pidfile, options.imports)

