#! /usr/bin/env python

###############################################################################
#   File: ParallelRunner.py
#
#   This file is part of prunner
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
################################################################################

from Jobs import *
from Clusters import *

class ParallelRunner(object):

    _instance = None

    def __new__(cls, *args, **kwargs):
        if not cls._instance:
            #cls._instance = super(ParallelRunner, cls).__new__(cls, *args, **kwargs)
            cls._instance = super(ParallelRunner, cls).__new__(cls)
        return cls._instance

    def __init__(self, configfile, jobfile = None):
        self._jobs = Jobs()
        self._clusters = Clusters(configfile, self._jobs)
        if jobfile:
            self._jobs.addJobsFromFile(jobfile)

    @property
    def clusters(self):
        return self._clusters

    @property
    def jobs(self):
        return self._jobs

    def clusterJobs(self):
        for c in self._clusters.clusters:
            for rec in c.threadStatus():
                yield rec

    def errorMsg(self, cname, cid):
        for rec in self._clusters.getCluster(cname).getClusterThread(cid).currentErrorMsg():
            yield rec

    def clusterFinishedJobs(self):
        """ return a list of number of finished jobs on each cluster """
        return [ c.numFinishedJobs for c in self._clusters.clusters ]

    def clusterNames(self):
        """ return a list of names of the clusters """
        return [ c.clustername for c in self._clusters.clusters ]

    def totJobs(self):
        """ total number of jobs """
        return self._jobs.totJobs

if __name__ == '__main__':
    import sys
    import time
    c = ParallelRunner(sys.argv[1], sys.argv[2])
    time.sleep(100)
