#! /usr/bin/env python

###############################################################################
#   File: Jobs.py
#
#   This file is part of prunner
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
################################################################################

import Queue
import re
from string import Template

class Jobs:
    """ Manage jobs """
    def __init__(self, qsize=0):
        self._cmdPtn     = re.compile(r"(\d+)\s+(\d+)\s+(\S+.*$)")   # regu. expr for the command file
                                                                     # it should be like  "1 4 <cmd>" each line
        self._jobQueue   = Queue.Queue(qsize)
        self._totJobs    = 0

    @property
    def totJobs(self):
        return self._totJobs

    def addJobsFromCmd(self, cmd):
        g = self._cmdPtn.match(cmd)
        if not g: return False

        self.addSequentialJobs(g.group(3), int(g.group(1)), int(g.group(2)))
        return True

    def addJobsFromFile(self, file):
        fd = open(file, 'r')
        txt = fd.readline()
        lno = 1
        while txt:
            txt = txt.strip()
            if len(txt) > 0 and txt[0] != '#' and not self.addJobsFromCmd(txt):
                print >> sys.stderr, "Warning: Incorrect command line syntax at Line: %d in the file %s" % (lno, file)
            lno += 1
            txt = fd.readline()
        fd.close()

    def addSequentialJobs(self, cmd, beginId, endId):
        if beginId > endId:
            print >> sys.stderr, "Warning: Incorrect sequential job ID"
            return

        self._totJobs += (endId - beginId + 1)
        cmd = Template(cmd)
        for id in xrange(beginId, endId+1):
            self._jobQueue.put(cmd.substitute(ID=id), True)

    def nextCommand(self, timeout):
        try:
            return self._jobQueue.get(True, timeout)
        except Queue.Empty:
            return None
