###############################################################################
#   File: FileLog.py
#
#   This file is part of prunner
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
################################################################################
class FileLog:
    def __init__(self, filename):
        self._fd = open(filename, 'w')

    def __del__(self):
        self._fd.flush()
        self._fd.close()

    def newCommand(self, cmd):
        self._fd.write("\n$$$%s\n" % cmd)

    def errorMsg(self, msg):
        self._fd.write(msg)
        self._fd.flush()

    def readLog(self):
        """ read the current log """
        file = open(self._fd.name, 'r')
        txt = file.readline()
        while txt:
            yield txt
            txt = file.readline()
        file.close()
