###############################################################################
#   File: PlotGen.py
#
#   This file is part of prunner
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
################################################################################
import matplotlib
matplotlib.use('agg')

import numpy as np
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

def plot_cluster_finished_jobs(names, jobs, outfile):
    """ plot a figure about the finished jobs on each cluster

    name: the cluster names
    jobs: int list, number of finished jobs
    outfile: output figure file
    """
    def format_name(x, pos=None):
        return names[int(x)]

    color = ('#ca7900', '#bfd1d4');
    fig = plt.figure()
    #ax = fig.add_subplot(111)
    ax = fig.add_axes((0.04,0.22,0.93,0.71))
    cs = [ color[i%2] for i in xrange(len(jobs)) ]
    ax.bar(range(len(jobs)), jobs, width=0.9, bottom=0, color=cs, align='center')
    #ax.xaxis.set_major_locator(ticker.IndexLocator(1,0))
    ax.set_xlim(-0.5, len(jobs)-0.5)
    ax.xaxis.set_major_locator(ticker.FixedLocator(np.arange(len(jobs))))
    ax.xaxis.set_major_formatter(ticker.FuncFormatter(format_name))

    fig.autofmt_xdate()
    fig.set_size_inches(8.0,8.0*0.3)
    plt.savefig(outfile)
    fig.clf()
    plt.close(fig)

if __name__ == '__main__':
    names = ['hydra1', 'hydra2', 'hydra3', 'hydra10', 'hydra11', 'hydra12']
    jobs  = [0, 0, 0, 1, 2, 4]
    plot_cluster_finished_jobs(names, jobs, 'test.png')
