#!/usr/bin/env python

###############################################################################
#   File: MonitorPage.py
#
#   This file is part of prunner
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
################################################################################


##################################################
## DEPENDENCIES
import sys
import os
import os.path
from os.path import getmtime, exists
import time
import types
import __builtin__
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import DummyTransaction
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers

##################################################
## MODULE CONSTANTS
try:
    True, False
except NameError:
    True, False = (1==1), (1==0)
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.0.1'
__CHEETAH_versionTuple__ = (2, 0, 1, 'final', 0)
__CHEETAH_genTime__ = 1270354121.770551
__CHEETAH_genTimestamp__ = 'Sat Apr  3 21:08:41 2010'
__CHEETAH_src__ = 'MonitorPage.tmpl'
__CHEETAH_srcLastModified__ = 'Sat Apr  3 21:08:27 2010'
__CHEETAH_docstring__ = 'Autogenerated by CHEETAH: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class MonitorPage(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        Template.__init__(self, *args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\r
<html xmlns="http://www.w3.org/1999/xhtml">\r
<head>\r
<meta http-equiv="content-type" content="text/html; charset=utf-8" />\r
<meta http-equiv="refresh" content="15" />\r
<title>Cluster Job Monitor</title>\r
<meta name="keywords" content="" />\r
<meta name="description" content="" />\r
<link href="css/default.css" rel="stylesheet" type="text/css" />\r
<link href="css/orangebrownie.css" rel="stylesheet" type="text/css" />\r
</head>\r
<body>\r
<!-- start header -->\r
<div id="header">\r
  <div id="menu">\r
    <ul>\r
      <li class="current_page_item"><a href="#">Monitor</a></li>\r
      <li><a href="/manage">Manage</a></li>\r
      <li><a href="#">About</a></li>\r
      <li class="last"><a href="#">Contact</a></li>\r
    </ul>\r
  </div>\r
</div>\r
<div id="logo">\r
  <h1>Parallel Cluster Monitor<!--<a href="#"></a>--></h1>\r
  <!-- <h2> Design by Free Css Templates</h2> -->\r
</div>\r
<!-- end header -->\r
<!-- start page -->\r
<div id="page">\r
  <!-- start content -->\r
  <div id="content">\r
\r
  <div class="post">\r
    <h2 class="title">Running Jobs:</h2>\r
    <div class="entry">\r
    <div id="itsthetable" align=center>\r
    <table id="mytable" cellspacing="0" summary="">\r
    <!-- <caption>Table 1: Power Mac G5 tech specs </caption> -->\r
      <thead> <tr>\r
        <th scope="col" style="text-align: center">Cluster</th>\r
        <th scope="col">St</th>\r
        <th scope="col">Job #</th>\r
        <th scope="col">Running Command</th>\r
      </tr> </thead>\r
\r
      <tbody>\r
''')
        totJobs = 0
        cnt = 0
        for cname, cid, status, fjobs, cmd in VFN(VFFSL(SL,"clusters",True),"clusterJobs",False)(): # generated from line 50, col 5
            if VFFSL(SL,"cnt",True) > 0: # generated from line 51, col 7
                write('''        <tr class="odd">\r
''')
            else: # generated from line 53, col 7
                write('''        <tr>\r
''')
            write('''\r
''')
            if VFFSL(SL,"len",False)(VFFSL(SL,"status",True)) > 1: # generated from line 57, col 7
                write('''          <th scope="row"><a href="/errors/''')
                _v = VFFSL(SL,"cname",True) # '$cname' on line 58, col 44
                if _v is not None: write(_filter(_v, rawExpr='$cname')) # from line 58, col 44.
                write('''/''')
                _v = VFFSL(SL,"cid",True) # '$cid' on line 58, col 51
                if _v is not None: write(_filter(_v, rawExpr='$cid')) # from line 58, col 51.
                write('''">''')
                _v = VFFSL(SL,"cname",True) # '$cname' on line 58, col 57
                if _v is not None: write(_filter(_v, rawExpr='$cname')) # from line 58, col 57.
                write(''' #''')
                _v = VFFSL(SL,"cid",True) # '$cid' on line 58, col 65
                if _v is not None: write(_filter(_v, rawExpr='$cid')) # from line 58, col 65.
                write('''</a></th>\r
          <td style="text-align: center; background: #C60000">''')
                _v = VFFSL(SL,"status",True) # '$status' on line 59, col 63
                if _v is not None: write(_filter(_v, rawExpr='$status')) # from line 59, col 63.
                write('''</th>\r
''')
            else: # generated from line 60, col 7
                write('''          <th scope="row">''')
                _v = VFFSL(SL,"cname",True) # '$cname' on line 61, col 27
                if _v is not None: write(_filter(_v, rawExpr='$cname')) # from line 61, col 27.
                write(''' #''')
                _v = VFFSL(SL,"cid",True) # '$cid' on line 61, col 35
                if _v is not None: write(_filter(_v, rawExpr='$cid')) # from line 61, col 35.
                write('''</th>\r
          <td style="text-align: center">''')
                _v = VFFSL(SL,"status",True) # '$status' on line 62, col 42
                if _v is not None: write(_filter(_v, rawExpr='$status')) # from line 62, col 42.
                write('''</th>\r
''')
            write('''          <td style="text-align: center">''')
            _v = VFFSL(SL,"fjobs",True) # '$fjobs' on line 64, col 42
            if _v is not None: write(_filter(_v, rawExpr='$fjobs')) # from line 64, col 42.
            write('''</td>\r
          <td>''')
            _v = VFFSL(SL,"cmd",True) # '$cmd' on line 65, col 15
            if _v is not None: write(_filter(_v, rawExpr='$cmd')) # from line 65, col 15.
            write('''</td>\r
        </tr>\r
''')
            cnt = 1-VFFSL(SL,"cnt",True)
            totJobs += VFFSL(SL,"fjobs",True)
        write('''      </tbody>\r
\r
      <tfoot> <tr>\r
        <th scope="col">Total Jobs</th>\r
        <td colspan="4" style="text-align: right">''')
        _v = VFFSL(SL,"totJobs",True) # '$totJobs' on line 74, col 51
        if _v is not None: write(_filter(_v, rawExpr='$totJobs')) # from line 74, col 51.
        write(''' / ''')
        _v = VFN(VFFSL(SL,"clusters",True),"totJobs",False)() # '$clusters.totJobs()' on line 74, col 62
        if _v is not None: write(_filter(_v, rawExpr='$clusters.totJobs()')) # from line 74, col 62.
        write('''</th>\r
      </tr> </tfoot>\r
    </table>\r
    </div>\r
    </div>\r
  <br/>\r
  <div class="post">\r
    <h2 class="title">Finished Jobs</h2>\r
    <div class="entry">\r
      <img src="img/finished_jobs.png" alt="finished jobs"/>\r
''')
        percentage = '%.2f%%' % (VFFSL(SL,"totJobs",True)*100. / VFN(VFFSL(SL,"clusters",True),"totJobs",False)())
        write('''      <div id="progress-bar">\r
          <div id="progress-level" style="width: ''')
        _v = VFFSL(SL,"percentage",True) # '$percentage' on line 86, col 50
        if _v is not None: write(_filter(_v, rawExpr='$percentage')) # from line 86, col 50.
        write('''"> \r
              <div id="progress-text">''')
        _v = VFFSL(SL,"percentage",True) # '$percentage' on line 87, col 39
        if _v is not None: write(_filter(_v, rawExpr='$percentage')) # from line 87, col 39.
        write('''%</div>\r
          </div>\r
      </div>\r
    </div>\r
  </div>\r
\r
    <!--\r
      <div class="meta">\r
        <p class="byline">Posted on July 21, 2007 byFreeCssTemplates</p>\r
        <p class="links"><a href="#" class="more">Read full article</a> <b>|</b> <a href="#" class="comments">Comments (32)</a></p>\r
      </div>\r
    -->\r
  </div>\r
</div>\r
\r
<!-- end sidebar -->\r
<div style="clear: both;">&nbsp;</div>\r
</div>\r
\r
<!-- start footer -->\r
<div id="footer">\r
  <div id="footer-wrap">\r
    <p id="legal">(c) 2010 <a href="http://www.cs.cornell.edu/~cxzheng">Changxi Zheng</a>.</p>\r
  </div>\r
</div>\r
<!-- end footer -->\r
</body>\r
</html>\r
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_MonitorPage= 'respond'

## END CLASS DEFINITION

if not hasattr(MonitorPage, '_initCheetahAttributes'):
    templateAPIClass = getattr(MonitorPage, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(MonitorPage)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=MonitorPage()).run()


