#!/usr/bin/env python

###############################################################################
#   File: ManagePage.py
#
#   This file is part of prunner
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
################################################################################


##################################################
## DEPENDENCIES
import sys
import os
import os.path
import __builtin__
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.1'
__CHEETAH_versionTuple__ = (2, 4, 1, 'final', 0)
__CHEETAH_genTime__ = 1270407465.01123
__CHEETAH_genTimestamp__ = 'Sun Apr  4 14:57:45 2010'
__CHEETAH_src__ = 'tmpl/ManagePage.tmpl'
__CHEETAH_srcLastModified__ = 'Sun Apr  4 14:57:24 2010'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class ManagePage(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(ManagePage, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>Cluster Job Manager</title>
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="/css/default.css" rel="stylesheet" type="text/css" />
<link href="/css/orangebrownie.css" rel="stylesheet" type="text/css" />
</head>

<script type="text/javascript">
function checkAll(field) {
    for(i=0;i < field.length;++ i)
        field[i].checked = true;
}

function uncheckAll(field) {
    for(i=0;i < field.length;++ i)
        field[i].checked = false;
}

function submitForm(form, action) {
    form.action = action;
    form.submit();
}
</script>

''')
        if VFSL([locals()]+SL+[globals(), __builtin__],"message",True) is None: # generated from line 29, col 1
            write(u'''<body>
''')
        else: # generated from line 31, col 1
            write(u'''<body onLoad="alert(\'''')
            _v = VFSL([locals()]+SL+[globals(), __builtin__],"message",True) # u'$message' on line 32, col 22
            if _v is not None: write(_filter(_v, rawExpr=u'$message')) # from line 32, col 22.
            write(u'''\')">
''')
        write(u'''<!-- start header -->
<div id="header">
  <div id="menu">
    <ul>
      <li><a href="/monitor">Monitor</a></li>
\t<li class="current_page_item"><a href="#">Manage</a></li>
\t<li><a href="#">About</a></li>
\t<li class="last"><a href="#">Contact</a></li>
    </ul>
  </div>
</div>
<div id="logo">
\t<h1>Parallel Cluster Management</h1>
\t<!-- <h2> Design by Free Css Templates</h2> -->
</div>
<!-- end header -->
<!-- start page -->
<div id="page">
  <!-- start content -->
  <div id="content">

  <div class="post">
    <h2 class="title">Running Jobs:</h2>
    <div class="entry">
    <div id="itsthetable" align=center>
    <form name="cluster_table" action="active_clusters" method="POST">
    <table id="mytable" cellspacing="0" summary="">
      <!-- <caption>Table 1: Power Mac G5 tech specs </caption> -->
        <thead> <tr>
          <th scope="col"></th>
          <th scope="col">Cluster</th>
          <th scope="col">St</th>
          <th scope="col">Job #</th>
          <th scope="col">Running Command</th>
        </tr> </thead>

    <tbody>
''')
        totJobs = 0
        cnt = 0
        for cname, cid, status, fjobs, cmd in VFN(VFSL([locals()]+SL+[globals(), __builtin__],"clusters",True),"clusterJobs",False)(): # generated from line 73, col 5
            if VFSL([locals()]+SL+[globals(), __builtin__],"cnt",True) > 0: # generated from line 74, col 7
                write(u'''        <tr class="odd">
''')
            else: # generated from line 76, col 7
                write(u'''        <tr>
''')
            checkid = "%s::%d" % (VFSL([locals()]+SL+[globals(), __builtin__],"cname",True), VFSL([locals()]+SL+[globals(), __builtin__],"cid",True))
            write(u'''        <td><input type="checkbox" name="selection" value="''')
            _v = VFSL([locals()]+SL+[globals(), __builtin__],"checkid",True) # u'$checkid' on line 80, col 60
            if _v is not None: write(_filter(_v, rawExpr=u'$checkid')) # from line 80, col 60.
            write(u'''" /></td>
''')
            if VFSL([locals()]+SL+[globals(), __builtin__],"len",False)(VFSL([locals()]+SL+[globals(), __builtin__],"status",True)) > 1: # generated from line 81, col 7
                write(u'''        <th scope="row"><a href="/errors/''')
                _v = VFSL([locals()]+SL+[globals(), __builtin__],"cname",True) # u'$cname' on line 82, col 42
                if _v is not None: write(_filter(_v, rawExpr=u'$cname')) # from line 82, col 42.
                write(u'''/''')
                _v = VFSL([locals()]+SL+[globals(), __builtin__],"cid",True) # u'$cid' on line 82, col 49
                if _v is not None: write(_filter(_v, rawExpr=u'$cid')) # from line 82, col 49.
                write(u'''">''')
                _v = VFSL([locals()]+SL+[globals(), __builtin__],"cname",True) # u'$cname' on line 82, col 55
                if _v is not None: write(_filter(_v, rawExpr=u'$cname')) # from line 82, col 55.
                write(u''' #''')
                _v = VFSL([locals()]+SL+[globals(), __builtin__],"cid",True) # u'$cid' on line 82, col 63
                if _v is not None: write(_filter(_v, rawExpr=u'$cid')) # from line 82, col 63.
                write(u'''</a></th>
        <td style="text-align: center; background: #C60000">''')
                _v = VFSL([locals()]+SL+[globals(), __builtin__],"status",True) # u'$status' on line 83, col 61
                if _v is not None: write(_filter(_v, rawExpr=u'$status')) # from line 83, col 61.
                write(u'''</th>
''')
            else: # generated from line 84, col 7
                write(u'''        <th scope="row">''')
                _v = VFSL([locals()]+SL+[globals(), __builtin__],"cname",True) # u'$cname' on line 85, col 25
                if _v is not None: write(_filter(_v, rawExpr=u'$cname')) # from line 85, col 25.
                write(u''' #''')
                _v = VFSL([locals()]+SL+[globals(), __builtin__],"cid",True) # u'$cid' on line 85, col 33
                if _v is not None: write(_filter(_v, rawExpr=u'$cid')) # from line 85, col 33.
                write(u'''</th>
        <td style="text-align: center">''')
                _v = VFSL([locals()]+SL+[globals(), __builtin__],"status",True) # u'$status' on line 86, col 40
                if _v is not None: write(_filter(_v, rawExpr=u'$status')) # from line 86, col 40.
                write(u'''</th>
''')
            write(u'''        <td style="text-align: center">''')
            _v = VFSL([locals()]+SL+[globals(), __builtin__],"fjobs",True) # u'$fjobs' on line 88, col 40
            if _v is not None: write(_filter(_v, rawExpr=u'$fjobs')) # from line 88, col 40.
            write(u'''</td>
        <td>''')
            _v = VFSL([locals()]+SL+[globals(), __builtin__],"cmd",True) # u'$cmd' on line 89, col 13
            if _v is not None: write(_filter(_v, rawExpr=u'$cmd')) # from line 89, col 13.
            write(u'''</td> </tr>
''')
            cnt = 1-VFSL([locals()]+SL+[globals(), __builtin__],"cnt",True)
            totJobs += VFSL([locals()]+SL+[globals(), __builtin__],"fjobs",True)
        write(u'''        </tbody>

        <tfoot> <tr>
        <th scope="col">Total Jobs</th>
        <td colspan="4" style="text-align: right">''')
        _v = VFSL([locals()]+SL+[globals(), __builtin__],"totJobs",True) # u'$totJobs' on line 97, col 51
        if _v is not None: write(_filter(_v, rawExpr=u'$totJobs')) # from line 97, col 51.
        write(u''' / ''')
        _v = VFN(VFSL([locals()]+SL+[globals(), __builtin__],"clusters",True),"totJobs",False)() # u'$clusters.totJobs()' on line 97, col 62
        if _v is not None: write(_filter(_v, rawExpr=u'$clusters.totJobs()')) # from line 97, col 62.
        write(u'''</th>
        </tr> </tfoot>
      </table>
      <input type="button" name="Select All" value="Select All" 
             onClick="checkAll(document.cluster_table.selection)">
      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      <input type="button" name="Deselect All" value="Deselect All" 
             onClick="uncheckAll(document.cluster_table.selection)">
      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      <input type="button" value="Enable" onClick="submitForm(this.form, \'enable_clusters\')"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      <input type="button" value="Disable" onClick="submitForm(this.form, \'disable_clusters\')"/>
    </form>
    </div>
    </div>
  </div>

  <div class="post">
    <h2 class="title">Submitting Jobs</h2>
    <div class="entry">
      <!-- <p> Finished Jobs </p> -->
      <p><h3> submitting from file:
      <form action="submit_cmd_file" method="POST" enctype="multipart/form-data">
          <input type="file" name="cmdFile"/> <input type="submit"/>
      </form></p>
        
      <p><h3>
      paste command here:
      <form action="submit_cmd_txt" method="POST" style="text-align: center">
      <textarea name="commands" cols="110" rows="8"></textarea>
      <input type="submit"/>
      </form></h3></p>
      </h3>
    </div>
  </div>
</div>

<!-- end sidebar -->
<div style="clear: both;">&nbsp;</div>
</div>

<!-- start footer -->
<div id="footer">
  <div id="footer-wrap">
    <p id="legal">(c) 2010 <a href="http://www.cs.cornell.edu/~cxzheng">Changxi Zheng</a>.</p>
  </div>
</div>
<!-- end footer -->
</body>
</html>

''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_ManagePage= 'respond'

## END CLASS DEFINITION

if not hasattr(ManagePage, '_initCheetahAttributes'):
    templateAPIClass = getattr(ManagePage, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(ManagePage)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=ManagePage()).run()


