#!/usr/bin/env python

###############################################################################
#   File: ErrorPage.py
#
#   This file is part of prunner
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
################################################################################

##################################################
## DEPENDENCIES
import sys
import os
import os.path
from os.path import getmtime, exists
import time
import types
import __builtin__
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import DummyTransaction
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers

##################################################
## MODULE CONSTANTS
try:
    True, False
except NameError:
    True, False = (1==1), (1==0)
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.0.1'
__CHEETAH_versionTuple__ = (2, 0, 1, 'final', 0)
__CHEETAH_genTime__ = 1270352585.6093781
__CHEETAH_genTimestamp__ = 'Sat Apr  3 20:43:05 2010'
__CHEETAH_src__ = 'ErrorPage.tmpl'
__CHEETAH_srcLastModified__ = 'Sat Apr  3 20:42:36 2010'
__CHEETAH_docstring__ = 'Autogenerated by CHEETAH: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class ErrorPage(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        Template.__init__(self, *args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>Cluster Job Error Message</title>
<meta name="keywords" content="" />
<meta name="description" content="" />
<link href="/css/default.css" rel="stylesheet" type="text/css" />
<link href="/css/orangebrownie.css" rel="stylesheet" type="text/css" />
</head>
<body>
<!-- start header -->
<div id="header">
  <div id="menu">
    <ul>
      <li><a href="/monitor">Monitor</a></li>
      <li><a href="/manage">Manage</a></li>
      <li><a href="#">About</a></li>
      <li class="last"><a href="#">Contact</a></li>
    </ul>
  </div>
</div>
<div id="logo">
  <h1>Error Messsage for ''')
        _v = VFFSL(SL,"cname",True) # '$cname' on line 24, col 26
        if _v is not None: write(_filter(_v, rawExpr='$cname')) # from line 24, col 26.
        write('''-''')
        _v = VFFSL(SL,"cid",True) # '$cid' on line 24, col 33
        if _v is not None: write(_filter(_v, rawExpr='$cid')) # from line 24, col 33.
        write('''</h1>
</div>
<!-- end header -->
<!-- start page -->
<div id="page"> <div id="content">
''')
        for cmd, errmsg in VFN(VFFSL(SL,"clusters",True),"errorMsg",False)(VFFSL(SL,"cname",True), VFFSL(SL,"cid",True)): # generated from line 29, col 1
            write('''  <div class="post">
    <h3 class="title">Command: <code>''')
            _v = VFFSL(SL,"cmd",True) # '$cmd' on line 31, col 38
            if _v is not None: write(_filter(_v, rawExpr='$cmd')) # from line 31, col 38.
            write('''</code></h3>
    <div class="entry">
    <pre><code>
''')
            _v = VFFSL(SL,"errmsg",True) # '$errmsg' on line 34, col 1
            if _v is not None: write(_filter(_v, rawExpr='$errmsg')) # from line 34, col 1.
            write('''
    </code><pre>
    </div>
  </div>
''')
        write('''</div> </div>

<!-- end sidebar -->
<div style="clear: both;">&nbsp;</div>
</div>

<!-- start footer -->
<div id="footer">
  <div id="footer-wrap">
    <p id="legal">(c) 2010 <a href="http://www.cs.cornell.edu/~cxzheng">Changxi Zheng</a>.</p>
  </div>
</div>
<!-- end footer -->
</body>
</html>

''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_ErrorPage= 'respond'

## END CLASS DEFINITION

if not hasattr(ErrorPage, '_initCheetahAttributes'):
    templateAPIClass = getattr(ErrorPage, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(ErrorPage)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=ErrorPage()).run()


