# - Find Intel MKL
FIND_PATH(MKL_INCLUDE_DIR mkl.h
    PATHS ENV INCLUDE
    PATHS ${SYSTEM_INC_PATH})

FIND_LIBRARY(MKL_LIBRARY mkl
    PATHS ENV LD_LIBRARY_PATH
    PATHS ${SYSTEM_LIB_PATH}
    PATHS ENV LIBRARY_PATH)

IF (MKL_INCLUDE_DIR AND MKL_LIBRARY)
    IF (NOT MKL_FIND_QUIETLY)
        MESSAGE(STATUS "Found MKL: ${MKL_LIBRARY}")
    ENDIF (NOT MKL_FIND_QUIETLY)
ELSE (MKL_INCLUDE_DIR AND MKL_LIBRARY)
    IF (MKL_FIND_REQUIRED)
        MESSAGE(FATAL_ERROR "Could not find MKL: $ENV{INCLUDE} $ENV{LD_LIBRARY_PATH}")
    ELSE (MKL_FIND_REQUIRED)
        IF ( NOT MKL_LIBRARY )
            MESSAGE(STATUS "WARNING: Could not find MKL library: $ENV{LD_LIBRARY_PATH}")
        ELSE ( NOT MKL_LIBRARY )
            MESSAGE(STATUS "WARNING: Could not find MKL include: $ENV{INCLUDE}")
        ENDIF ( NOT MKL_LIBRARY )
    ENDIF (MKL_FIND_REQUIRED)
ENDIF (MKL_INCLUDE_DIR AND MKL_LIBRARY)
