/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Bouncy
extends JFrame {
    public static final int DEFAULT_SIZE = 500;
    JPanel buttonPanel = new JPanel();
    JButton openButton = new JButton("Open");
    JButton runButton = new JButton("Run");
    JButton stepButton = new JButton("Step");
    JButton stopButton = new JButton("Stop");
    JFileChooser fileChooser = new JFileChooser();
    Timer timer;
    Balls balls = new Balls();
    View view = new View(this.balls);

    public static void main(String[] stringArray) {
        Bouncy bouncy = new Bouncy();
        if (stringArray.length > 0) {
            bouncy.init(stringArray[0]);
        } else {
            bouncy.init(null);
        }
        bouncy.setSize(500, 500);
        bouncy.setVisible(true);
        bouncy.setDefaultCloseOperation(3);
        bouncy.balls.notifyObservers();
    }

    public void init(String string) {
        boolean bl = false;
        this.layOutComponents();
        if (string != null) {
            bl = this.balls.setData(new File(string));
            this.setRunnable();
        }
        this.attachListenersToComponents();
        this.fileChooser.setCurrentDirectory(new File("."));
        this.balls.addObserver(this.view);
        this.balls.setLimits(this.view.getWidth(), this.view.getHeight());
    }

    private void layOutComponents() {
        this.setLayout(new BorderLayout());
        this.add("South", this.buttonPanel);
        this.buttonPanel.add(this.openButton);
        this.buttonPanel.add(this.runButton);
        this.buttonPanel.add(this.stepButton);
        this.buttonPanel.add(this.stopButton);
        this.setNoData();
        this.add("Center", this.view);
    }

    private void setNoData() {
        this.runButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.stopButton.setEnabled(false);
    }

    private void setRunnable() {
        this.runButton.setEnabled(true);
        this.stepButton.setEnabled(true);
        this.stopButton.setEnabled(false);
    }

    private void setStoppable() {
        this.runButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.stopButton.setEnabled(true);
    }

    private void attachListenersToComponents() {
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Bouncy.this.setStoppable();
                Bouncy.this.timer = new Timer(true);
                Bouncy.this.timer.schedule((TimerTask)new Strobe(), 0L, 40L);
            }
        });
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Bouncy.this.setRunnable();
                Bouncy.this.balls.setLimits(Bouncy.this.view.getWidth(), Bouncy.this.view.getHeight());
                Bouncy.this.setTitle(Bouncy.this.balls.makeOneStep() + "/" + Bouncy.this.balls.getNumFrames());
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Bouncy.this.setRunnable();
                Bouncy.this.timer.cancel();
            }
        });
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                Bouncy.this.setNoData();
                if (Bouncy.this.timer != null) {
                    Bouncy.this.timer.cancel();
                }
                if ((n = Bouncy.this.fileChooser.showOpenDialog(Bouncy.this)) == 0) {
                    if (Bouncy.this.balls.setData(Bouncy.this.fileChooser.getSelectedFile())) {
                        Bouncy.this.balls.setLimits(Bouncy.this.view.getWidth(), Bouncy.this.view.getHeight());
                        Bouncy.this.balls.notifyObservers();
                        Bouncy.this.setRunnable();
                    }
                } else {
                    Bouncy.this.setRunnable();
                }
            }
        });
    }

    private class Strobe
    extends TimerTask {
        private Strobe() {
        }

        public void run() {
            Bouncy.this.balls.setLimits(Bouncy.this.view.getWidth(), Bouncy.this.view.getHeight());
            Bouncy.this.setTitle(Bouncy.this.balls.makeOneStep() + "/" + Bouncy.this.balls.getNumFrames());
        }
    }
}

