/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.InputMismatchException;
import java.util.Observable;
import java.util.Scanner;
import java.util.Vector;

class Balls
extends Observable {
    public final int BALL_SIZE = 5;
    private Vector frames = new Vector();
    private Frame currentFrame;
    private float scale;
    private int xLimit = 495;
    private int yLimit = 495;
    private int numBalls;
    private int numFrames;
    private int currentFrameIndex;

    Balls() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setData(File file) {
        Scanner scanner = null;
        boolean bl = false;
        try {
            scanner = new Scanner(new BufferedReader(new FileReader(file)));
            String string = scanner.next();
            if (string.equals("SPHView00")) {
                this.readTextData(scanner);
                scanner.close();
            } else if (string.equals("SPHView01")) {
                scanner.close();
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                this.readBinData(dataInputStream);
                dataInputStream.close();
            } else {
                System.out.println("Unknown tag");
            }
            this.setChanged();
            bl = true;
        }
        catch (IOException iOException) {
            System.out.println("Failure during read");
        }
        catch (InputMismatchException inputMismatchException) {
            System.out.println("Malformed text input file");
        }
        finally {
            scanner.close();
        }
        return bl;
    }

    public void setLimits(int n, int n2) {
        this.xLimit = n - 5;
        this.yLimit = n2 - 5;
    }

    public int getNumBalls() {
        return this.numBalls;
    }

    public int getNumFrames() {
        return this.frames.size();
    }

    public int getX(int n) {
        return (int)(this.currentFrame.getX(n) / this.scale * (float)this.xLimit);
    }

    public int getY(int n) {
        return (int)((1.0f - this.currentFrame.getY(n) / this.scale) * (float)this.yLimit);
    }

    public Color getColor(int n) {
        if (this.currentFrame.getColor(n) == 0) {
            return Color.red;
        }
        return Color.blue;
    }

    public int makeOneStep() {
        ++this.currentFrameIndex;
        if (this.currentFrameIndex >= this.getNumFrames()) {
            this.currentFrameIndex = 0;
        }
        this.currentFrame = (Frame)this.frames.get(this.currentFrameIndex);
        this.setChanged();
        this.notifyObservers();
        return this.currentFrameIndex;
    }

    private void readTextData(Scanner scanner) throws IOException, InputMismatchException {
        this.frames.clear();
        this.currentFrameIndex = 0;
        this.numBalls = scanner.nextInt();
        this.scale = scanner.nextFloat();
        while (scanner.hasNextFloat()) {
            this.frames.add(new Frame().readTextFrame(scanner, this.numBalls));
        }
        if (scanner.hasNext()) {
            System.out.println("Quit at: '" + scanner.next() + "'");
        }
        this.currentFrame = (Frame)this.frames.get(this.currentFrameIndex);
    }

    private void readBinData(DataInputStream dataInputStream) throws IOException {
        this.frames.clear();
        this.currentFrameIndex = 0;
        dataInputStream.readLine();
        this.numBalls = dataInputStream.readInt();
        this.scale = dataInputStream.readFloat();
        try {
            while (true) {
                this.frames.add(new Frame().readBinFrame(dataInputStream, this.numBalls));
            }
        }
        catch (EOFException eOFException) {
            this.currentFrame = (Frame)this.frames.get(this.currentFrameIndex);
            return;
        }
    }
}

