% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function [S] = update_fault_stats(itr, S, fault_inds, seqs, fault_amt, space_ind)
% fault_inds: indices of where faults actually occur in the sequence
% S: data structure containing TP, FP, FN (true positive, false positive,
% false negative)
% seq: sequence to analyze

assert(length(fault_inds) == 1);

[guess_inds] = analyseqs(seqs);

% save fault index and fault amount
S(itr,1) = fault_inds;
S(itr,2) = fault_amt;
S(itr, 6) = space_ind;

% find true positive
TP = ismember(fault_inds, guess_inds) || ismember(fault_inds+1, guess_inds);
if TP
    S(itr,3) = 1;
end
if ismember(fault_inds+1, guess_inds) && ~ismember(fault_inds, guess_inds)
    S(itr,5) = 1;
end

% find false positive (ONLY BEFORE FAULT)
FP = sum((guess_inds < fault_inds));
S(itr,4) = FP;
end
