% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function [data_CN, data_BE, E, F] = run_heat_exp(data_file, num_trials, f_type, sigma)

rng(120);

% Setup
% diffusion parameter
load(data_file);
n_diff_CN_orig = n_diff_CN_Ri;
n_diff_BE_orig = n_diff_BE; %#ok<NODEF>

NX = length(linspace(0, 1, floor(1 / dx)));
NT = length(linspace(0, T, floor(T / dt)));
start_ind = 11;
fault_amt = rnor2(num_trials, sigma);
fault_times = randi([start_ind, NT-1], num_trials, 1);
fault_spaces = randi([1, NX-2], num_trials, 1);

data_CN = zeros(num_trials, 6);
data_BE = data_CN;

D = zeros(num_trials, 2);
E = zeros(num_trials, 2);
F = zeros(num_trials, 2);

fprintf('Progress ')
tic
for i = 1:num_trials
    %dt = dts(i);
    %fault_times(i) = randi([start_ind, floor(T / dt) - 1, 1, 1);
        
    [n_diff_CN, n_diff_BE, errs, lte_est] = heat_solve_update(K, f, T, dx, dt, ...
        fault_times(i), fault_spaces(i), fault_amt(i), ...
        U_CN, U_Ri, U_BE, U_FE, n_diff_CN_orig, n_diff_BE_orig, f_type);
    D(i, 1) = n_diff_CN_Ri(fault_times(i));
    D(i, 2) = n_diff_BE(fault_times(i));    
    E(i, :) = errs;
    F(i, :) = lte_est;
    
    data_CN = update_fault_stats(i, data_CN, fault_times(i), n_diff_CN, fault_amt(i), fault_spaces(i));
    data_BE = update_fault_stats(i, data_BE, fault_times(i), n_diff_BE, fault_amt(i), fault_spaces(i));
    
    %semilogy(n_diff_BE);
    %pause();
    
    if (~mod(i, 100))
        fprintf('|');
    end
end
fprintf('\n')
toc

sum(data_CN(:, 3)) / num_trials
sum(data_BE(:, 3)) / num_trials
sum(data_CN(:, 4)) / sum(fault_times - start_ind)
sum(data_BE(:, 4)) / sum(fault_times - start_ind)