% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

%%
% directory to put output
out_dir = '~/';

%%
% Runge-Kutta differences
if 0
close all;
time_ind = 80;
space_ind = 2;
amt = 3;
f_type = 'f_eval';
RK_ind = 1;
dt = 1 / 10;
T = 14;
mu = 2;
f = @(t,u) [u(2) mu*(1-u(1)^2)*u(2)-u(1)];
u0 = [1 0];
t0 = 0;

[ ~, ~, n_diff, ~, ~] = ...
ode_rk45_FT( u0, t0, T, f, dt, RK_ind, time_ind, amt, space_ind, f_type);
error_itr = analyseq(n_diff);

figure
% figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
width = 5;     % Width in inches
height = 3;    % Height in inches
alw = 0.75;    % AxesLineWidth
fsz = 12;      % Fontsize
lw = 1.5;      % LineWidth
msz = 8;       % MarkerSize
%%%%%%%%%%%%%%%%%%%%%%%%%%

% set figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf, 'Position', [pos(1) pos(2) width*100, height*100]); %<- Set size
set(gca, 'FontSize', fsz, 'LineWidth', alw); %<- Set properties
%%%%%%%%%%%%%%%%%%%%%%%%%


semilogy(1:length(n_diff), n_diff, 'b-', ...
         error_itr, n_diff(error_itr), 'ro', ...
         'LineWidth', lw, 'MarkerSize', msz);
xlabel('iteration (i)')
ylabel('D_i');
title('RK 4/5 differences');

% set more parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'InvertHardcopy','on');
set(gcf,'PaperUnits', 'inches');
papersize = get(gcf, 'PaperSize');
left = (papersize(1)- width)/2;
bottom = (papersize(2)- height)/2;
myfiguresize = [left, bottom, width, height];
set(gcf,'PaperPosition', myfiguresize);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

out_file = 'vdp2_rk';
print(sprintf('%s/%s', out_dir, out_file), ...
              '-depsc2','-r300');

end

%%
% Basic heat plot to show peaks
if 0
load('heat3b');

t_fault = 120;
x_fault = 40;
fault_amt = 0.995;
dt = 1 / 100;

% run with RHS_overall
[n_diff_CN_FE, n_diff_CN_Ri, n_diff_CN_DF, ...
    n_diff_BE, U_CN, U_Ri, U_BE, ~, U_DF, t, x, errs] = ...
     heat_solve(K, f, g, BC0, BC1, T, dx, dt, ...
     t_fault, x_fault, fault_amt);

close all;

figure
% figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
width = 10;     % Width in inches
height = 3;    % Height in inches
alw = 0.75;    % AxesLineWidth
fsz = 12;      % Fontsize
lw = 1.5;      % LineWidth
msz = 12;       % MarkerSize
%%%%%%%%%%%%%%%%%%%%%%%%%%

% set figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf, 'Position', [pos(1) pos(2) width*100, height*100]); %<- Set size
set(gca, 'FontSize', fsz, 'LineWidth', alw); %<- Set properties
%%%%%%%%%%%%%%%%%%%%%%%%%

subplot(1, 2, 1);
imagesc(x, t, U_BE);

title('Crank-Nicolson Solution');
ylabel('i{\Delta}t');
xlabel('x');

subplot(1, 2, 2);
semilogy(1:length(n_diff_CN_Ri), n_diff_CN_Ri, 'r--', 'LineWidth', lw); hold on;
semilogy(1:length(n_diff_BE), n_diff_BE, 'b', 'LineWidth', lw); hold off;
ylabel('D_i');
xlabel('i');
legend('Richardson / Crank-Nicolson', 'forward / backward Euler', 'Location', 'best');

% set more parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'InvertHardcopy','on');
set(gcf,'PaperUnits', 'inches');
papersize = get(gcf, 'PaperSize');
left = (papersize(1)- width)/2;
bottom = (papersize(2)- height)/2;
myfiguresize = [left, bottom, width, height];
set(gcf,'PaperPosition', myfiguresize);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%


out_file = 'heat_soln_diffs1';
print(sprintf('%s/%s', out_dir, out_file), ...
              '-depsc2','-r300');
end

%%
% Two-lookout detection
if 0
load('detector_results');
sigma = 0.05;
xmax =  1;
close all;
temp_dx = 1;
LTE_visk(data_CN_jump, data_BE_jump, D_jump, E_jump, F_jump, temp_dx, 1,'jump_only', [1e-5, 1e-3], sigma, xmax);
LTE_visk(data_CN_var, data_BE_var, D_var, E_var, F_var, temp_dx, 1,'var_only', [1e-5, 5e-4], sigma, xmax);
LTE_visk(data_CN_both, data_BE_both, D_both, E_both, F_both, temp_dx, 1,'jump_and_var', [1e-5, 1e-3], sigma, xmax);

end
%%
% One-step after detection
if 0
% The figure in the current version of the paper uses data from results8.mat.
% However, this similar data from heat_results_part1.mat is probably more 
% illustrative of what is going.  This will be updated in the next draft.
load('heat_results_part1');  
load('heat1b');
data = data_BE_1b(data_BE_1b(:, 5) == 1, :);
data = data(1, :);
close all;
t_fault = data(1);
x_fault = data(6);
fault_amt = data(2);
% Note: need to change f_type to f_eval in source file
% TODO: fix that dependency


figure;
% figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
width = 5;     % Width in inches
height = 4;    % Height in inches
alw = 0.75;    % AxesLineWidth
fsz = 9;      % Fontsize
lw = 1.5;      % LineWidth
msz = 12;       % MarkerSize
%%%%%%%%%%%%%%%%%%%%%%%%%%

% set figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf, 'Position', [pos(1) pos(2) width*100, height*100]); %<- Set size
set(gca, 'FontSize', fsz, 'LineWidth', alw); %<- Set properties
%%%%%%%%%%%%%%%%%%%%%%%%%



[~, ~, ~, n_diff_BE, ~, ~, U_BE, U_FE, ~, ~, ~, ~] = ...
    heat_solve(K, f, g, BC0, BC1, T, dx, dt, t_fault, x_fault, fault_amt);
plot(t_fault-8:t_fault+3, n_diff_BE(t_fault-8:t_fault+3), 'bo-', 'MarkerSize', 6, 'LineWidth', lw); hold on;
plot(t_fault, n_diff_BE(t_fault), 'b*', 'MarkerSize', msz, 'LineWidth', lw);
xlabel('Time step (i)');
ylabel('D_i');
title('Tardy error detection on heat equation');
legend('FE/BE difference', 'Step of fault', 'Location', 'NorthWest'); hold off


% set more parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'InvertHardcopy','on');
set(gcf,'PaperUnits', 'inches');
papersize = get(gcf, 'PaperSize');
left = (papersize(1)- width)/2;
bottom = (papersize(2)- height)/2;
myfiguresize = [left, bottom, width, height];
set(gcf,'PaperPosition', myfiguresize);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

out_file = 'tardy_detection';
print(sprintf('%s/%s', out_dir, out_file), ...
              '-depsc2','-r300');

          
          
figure;
% set figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf, 'Position', [pos(1) pos(2) width*100, height*100]); %<- Set size
set(gca, 'FontSize', fsz, 'LineWidth', alw); %<- Set properties
%%%%%%%%%%%%%%%%%%%%%%%%%          

N = length(U_BE(t_fault, :));
if 0 
figure
subplot(2, 1, 1);
semilogy(1:N, U_BE(t_fault, :), 'b', ...
     1:N, U_FE(t_fault, :), 'r');
subplot(2, 1, 2);
semilogy(1:N, U_BE(t_fault+1, :), 'b', ...
     1:N, U_FE(t_fault+1, :), 'r'); 
end
figure;
plot(1:N, abs(U_BE(t_fault-1, :) - U_FE(t_fault-1, :)), 'm', ...
     1:N, abs(U_BE(t_fault, :) - U_FE(t_fault, :)), 'b--', ...
     1:N, abs(U_BE(t_fault+1, :) - U_FE(t_fault+1, :)), 'r-.', ...
     'MarkerSize', msz, 'LineWidth', 1.25);
legend('Step before fault', 'Step of fault', 'Step after fault');
xlabel('i (vector component)');
ylabel('|BE(i) - FE(i)|');
title('Component-wise absolute difference BE/FE');


% set more parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'InvertHardcopy','on');
set(gcf,'PaperUnits', 'inches');
papersize = get(gcf, 'PaperSize');
left = (papersize(1)- width)/2;
bottom = (papersize(2)- height)/2;
myfiguresize = [left, bottom, width, height];
set(gcf,'PaperPosition', myfiguresize);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

out_file = 'tardy_detection_soln';
print(sprintf('%s/%s', out_dir, out_file), ...
              '-depsc2','-r300');
end
%%
% Navier-Stokes: previous solution
if 0
close all;
load('ns_prev');
LTE_vis_NS(data, E, F, dt, 'ns_prev', 1e-2, 2000, 1);

clear all;
% Navier-Stokes: pressure
load('ns_pressure');
LTE_vis_NS(data, E, F, dt, 'ns_pressure', 1e-2, 20, 0);
end
%%
% updated heat equation plots
if 0
% data
load('heat_results_part1');
load('heat_results_part2');
load('heat_results_part3');
close all;

% configuration 1
if 1
x_loc = 2; y_loc = 0.4; sigma_kr = 0.15; xmin = 1e-2; xmax = 4;

if 1
load('heat1a');
LTE_visk_heat(data_CN_1a, E_CN_1a, F_CN_1a, 1 / dx, 1 / dt, 'heat_1a_CN', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 0, 0);
load('heat1b');
LTE_visk_heat(data_CN_1b, E_CN_1b, F_CN_1b, 1 / dx, 1 / dt, 'heat_1b_CN', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 0, 0);
load('heat1c');
LTE_visk_heat(data_CN_1c, E_CN_1c, F_CN_1c, 1 / dx, 1 / dt, 'heat_1c_CN', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 0, 0);
end

if 1
load('heat1a');
LTE_visk_heat(data_BE_1a, E_BE_1a, F_BE_1a, 1 / dx, 1 / dt, 'heat_1a_BE', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 1, 1);
load('heat1b');
LTE_visk_heat(data_BE_1b, E_BE_1b, F_BE_1b, 1 / dx, 1 / dt, 'heat_1b_BE', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 1, 0);
load('heat1c');
LTE_visk_heat(data_BE_1c, E_BE_1c, F_BE_1c, 1 / dx, 1 / dt, 'heat_1c_BE', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 1, 0);
end

end

% configuration 2
if 1
x_loc = 3; y_loc = 0.4; sigma_kr = 0.5; xmin = 1e-2; xmax = 6;

load('heat2b');
load('heat2c');

if 1
load('heat2a');
LTE_visk_heat(data_CN_2a, E_CN_2a, F_CN_2a, 1 / dx, 1 / dt, 'heat_2a_CN', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 0, 0);
load('heat2b');
LTE_visk_heat(data_CN_2b, E_CN_2b, F_CN_2b, 1 / dx, 1 / dt, 'heat_2b_CN', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 0, 0);
load('heat2c');
LTE_visk_heat(data_CN_2c, E_CN_2c, F_CN_2c, 1 / dx, 1 / dt, 'heat_2c_CN', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 0, 0);
end
if 1
load('heat2a');
LTE_visk_heat(data_BE_2a, E_BE_2a, F_BE_2a, 1 / dx, 1 / dt, 'heat_2a_BE', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 1, 1);
load('heat2b');
LTE_visk_heat(data_BE_2b, E_BE_2b, F_BE_2b, 1 / dx, 1 / dt, 'heat_2b_BE', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 1, 0);
load('heat2c');
LTE_visk_heat(data_BE_2c, E_BE_2c, F_BE_2c, 1 / dx, 1 / dt, 'heat_2c_BE', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 1, 0); 
end
end

% configuration 3
if 1
x_loc = 1; y_loc = 0.4; sigma_kr = 0.3; xmin = 1e-2; xmax = 2;

load('heat3b');
load('heat3c');

if 1
load('heat3a');
LTE_visk_heat(data_CN_3a, E_CN_3a, F_CN_3a, 1 / dx, 1 / dt, 'heat_3a_CN', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 0, 0);
load('heat3b');
LTE_visk_heat(data_CN_3b, E_CN_3b, F_CN_3b, 1 / dx, 1 / dt, 'heat_3b_CN', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 0, 0);
load('heat3c');
LTE_visk_heat(data_CN_3c, E_CN_3c, F_CN_3c, 1 / dx, 1 / dt, 'heat_3c_CN', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 1, 0);
end
if 1
load('heat3a');
LTE_visk_heat(data_BE_3a, E_BE_3a, F_BE_3a, 1 / dx, 1 / dt, 'heat_3a_BE', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 1, 1);
load('heat3b');
LTE_visk_heat(data_BE_3b, E_BE_3b, F_BE_3b, 1 / dx, 1 / dt, 'heat_3b_BE', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 1, 0);
load('heat3c');
LTE_visk_heat(data_BE_3c, E_BE_3c, F_BE_3c, 1 / dx, 1 / dt, 'heat_3c_BE', ...
    x_loc, y_loc, sigma_kr, xmin, xmax, 1, 0);
end
end
end
%%
%
if 0
load('detector_results');
load('heat_results_part2');
load('heat2b');

x_loc = 3; y_loc = 0.4; sigma_kr = 0.5; xmin = 1e-2; xmax = 6;
LTE_visk_heat_overlay(data_BE_2b_jump, E_2b_jump(:, 2), F_2b_jump(:, 2), ...
    1 / dx, 1 / dt, 'jump_only', x_loc, y_loc, sigma_kr, xmin, xmax, 'jump', 1, ...
    data_BE_2b, E_BE_2b, F_BE_2b);
LTE_visk_heat_overlay(data_BE_2b_var, E_2b_var(:, 2), F_2b_var(:, 2), ...
    1 / dx, 1 / dt, 'var_only', x_loc, y_loc, sigma_kr, xmin, xmax, 'var', 1, ...
    data_BE_2b, E_BE_2b, F_BE_2b);
end

%%
% ODEs
if 0
close all;

% function evals
if 1
clear all; load('RK_vdp_2_func');
LTE_vis_RK(data_RK45, D45, E45, F45, mu, 1 / dt, 'rk45_vdp_2_func', 0.25, 'RK45', 0);
LTE_vis_RK(data_RK23, D23, E23, F23, mu, 1 / dt, 'rk23_vdp_2_func', 0.15, 'RK23', 0);

clear all; load('AB_vdp_2_func');
LTE_vis_RK(data_AB45, D45, E45, F45, mu, 1 / dt, 'ab45_vdp_2_func', 0.25, 'AB45', 0);
LTE_vis_RK(data_AB23, D23, E23, F23, mu, 1 / dt, 'ab23_vdp_2_func', 0.35, 'AB23', 1);
end

if 1
clear all; load('RK_vdp_3_func');
LTE_vis_RK(data_RK45, D45, E45, F45, mu, 1 / dt, 'rk45_vdp_3_func', 0.25, 'RK45', 0);
LTE_vis_RK(data_RK23, D23, E23, F23, mu, 1 / dt, 'rk23_vdp_3_func', 0.25, 'RK23', 0);

clear all; load('AB_vdp_3_func');
LTE_vis_RK(data_AB45, D45, E45, F45, mu, 1 / dt, 'ab45_vdp_3_func', 0.25, 'AB45', 0);
LTE_vis_RK(data_AB23, D23, E23, F23, mu, 1 / dt, 'ab23_vdp_3_func', 0.25, 'AB23', 0);
end

% previous solution
if 1
clear all; load('RK_vdp_2_prev');
LTE_vis_RK(data_RK45, D45, E45, F45, mu, 1 / dt, 'rk45_vdp_2_prev', 0.4, 'RK45', 0);
LTE_vis_RK(data_RK23, D23, E23, F23, mu, 1 / dt, 'rk23_vdp_2_prev', 0.4, 'RK23', 0);

clear all; load('AB_vdp_2_prev');
LTE_vis_RK(data_AB45, D45, E45, F45, mu, 1 / dt, 'ab45_vdp_2_prev', 0.25, 'AB45', 0);
LTE_vis_RK(data_AB23, D23, E23, F23, mu, 1 / dt, 'ab23_vdp_2_prev', 0.35, 'AB23', 1);
end

if 1
clear all; load('RK_vdp_3_prev');
LTE_vis_RK(data_RK45, D45, E45, F45, mu, 1 / dt, 'rk45_vdp_3_prev', 0.25, 'RK45', 0);
LTE_vis_RK(data_RK23, D23, E23, F23, mu, 1 / dt, 'rk23_vdp_3_prev', 0.15, 'RK23', 0);

clear all; load('AB_vdp_3_prev');
LTE_vis_RK(data_AB45, D45, E45, F45, mu, 1 / dt, 'ab45_vdp_3_prev', 0.25, 'AB45', 0);
LTE_vis_RK(data_AB23, D23, E23, F23, mu, 1 / dt, 'ab23_vdp_3_prev', 0.25, 'AB23', 0);
end

end