% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function [ U, T, n_diff, err, LTE ] = ...
    ode_rk45_FT( u0, t0, tmax, f, h, ind, t_fault, fault_amt, x_fault, f_type)

order = size(u0,2);             % order
T = t0:h:tmax;
NT = length(T);

U = zeros(NT, order);
T(1) = t0;
U(1,:) = u0;

u = u0;                         % initialize u

% extra output
n_diff = zeros(NT, 1);

if strcmp(f_type, 'prev_soln')
    ind = -1;
end

%% Main loop
for i = 2:NT
    t = T(i);

    if i == t_fault && strcmp(f_type, 'prev_soln')
       u(x_fault) = u(x_fault) * fault_amt; 
    end
    
    [rk4_update, rk5_update] = ...
        faulty_rk45(f, t, u, h, i, t_fault, fault_amt, x_fault, ind);
    
    % find the difference in rk4 and rk5 update
    n_diff(i) = norm(rk5_update-rk4_update, 'inf');

    u = u + rk5_update;
    U(i, :) = u;
    
    if i == t_fault
        u_last = U(i-1,:);
        [rk4_update_good, rk5_update_good] = ...
            faulty_rk45(f, t, u_last, h, i, -1, fault_amt, x_fault, ind);
        if strcmp(f_type, 'prev_soln')
            err = norm(u_last + rk5_update - U(i, :), 'inf');
        else
            err = norm(rk5_update - rk5_update_good, 'inf');
        end
        LTE = norm(rk4_update_good - rk5_update_good, 'inf');
    end
end

