% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function [ U, T, n_diff, err, LTE ] = ...
        ode_ab34_FT(u0, t0, tmax, f, h, t_fault, fault_amt, x_fault)

order = size(u0,2); 
T = t0:h:tmax;
NT = length(T);

U = zeros(NT, order);
U(1,:) = u0;

n_diff = zeros(NT, 1);

err = -1;
LTE = -1;

% Runge-Kutta for the first 2 steps
for j = 1:2
    % Calculate slopes
    k1 = f(T(j), U(j,:));
    k2 = f(T(j)+h/2, U(j,:)+h*k1/2);
    k3 = f(T(j)+h/2, U(j,:)+h*k2/2);
    k4 = f(T(j)+h, U(j,:)+h*k3);
    % Calculate update
    rk4_update = h/6*(k1 + 2*k2 + 2*k3 + k4);
    
    U(j+1,:) = U(j,:) + rk4_update;
end

% initialize f's
fj1 = f(T(3), U(3,:));
fj2 = f(T(2), U(2,:));
fj3 = f(T(1), U(1,:));
% Adams-Bashforth updates
for j = 3:length(T)
    fj = f(T(j), U(j, :));
    if j == t_fault
        fj(x_fault) = fj(x_fault) * fault_amt;
    end
    
    % calculate updates
    ab3_update = h/12*(23* fj - 16* fj1 + 5 * fj2);
    ab4_update = h/24*(55* fj - 59* fj1 +37 * fj2 - 9 * fj3 );
    
    % check difference
    n_diff(j) = norm(ab4_update - ab3_update, 'inf');
    
    if j == t_fault
        fj_good = f(T(j), U(j,:));
        ab3_update_good = h/12*(23* fj_good - 16* fj1 + 5 * fj2);        
        ab4_update_good = h/24*(55* fj_good - 59* fj1 +37 * fj2 - 9 * fj3 );
        err = norm(ab4_update - ab4_update_good, 'inf');
        LTE = norm(ab4_update_good - ab3_update_good, 'inf');        
    end
    
    % add update
    U(j+1,:) = U(j,:) + ab4_update;
    
    % Update f's
    fj3 = fj2;
    fj2= fj1;
    fj1 = fj;
end

U = U(1:end-1,:);
