% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

%%
close all
rng(12);

Re = 2000;     % Reynolds number
dt = 1 / 100;    % time step
T = 2e-0;    % final time
lx = 1;       % width of box
ly = 1;       % height of box
nx = 40;      % number of x-gridpoints
ny = 40;      % number of y-gridpoints
f = @(x, y, t) 0 * x' * y;

[U_save, V_save, u_diff_save, v_diff_save, u_expl_diff_save, v_expl_diff_save] = ...
 navierstokes(Re, dt, T, lx, ly, nx, ny, f, 0, -1, -1);

num_trials = 2000;
start_ind = 12;
sigma = 5e-1;
fault_amts = rnor2(num_trials, sigma); 
fault_times = randi([start_ind, floor(T / dt)], num_trials, 1);
fault_spaces = randi([1, nx - 3], num_trials, 2);
E = zeros(num_trials, 1);
F = zeros(num_trials, 1);

data = zeros(num_trials,4);

fprintf('Progress ')
tic
for i = 1:num_trials
    t_fault = fault_times(i);
    [U_curr, V_curr, u_diff, v_diff, u_expl_diff, v_expl_diff] = ...
       ns_update(Re, dt, T, lx, ly, nx, ny, f, ...
        fault_amts(i), t_fault, fault_spaces(i, :), ...
        U_save, V_save, u_diff_save, v_diff_save, u_expl_diff_save, v_expl_diff_save);
    seqs = [u_diff, v_diff];    
    data = update_fault_stats(i, data, fault_times(i), ...
                              seqs, fault_amts(i), fault_spaces(i, 1));
    % Compute numerator of LTE-normalized error
    UU = abs(U_curr(t_fault, :, :) - U_save(t_fault, :, :));
    VV = abs(V_curr(t_fault, :, :) - V_save(t_fault, :, :));
    E(i) = max(max(UU(:)), max(VV(:)));
    F(i) = max(u_diff_save(t_fault), v_diff_save(t_fault));
    if (~mod(i, 25))
        fprintf('|');
    end
end
fprintf('\n')
toc

sum(data(:, 3)) / num_trials
sum(data(:, 4)) / sum(fault_times - start_ind)
LTE_vis_NS(data, E, F, dt, 'ns_prev1', 1e-2);
save('ns_prev');
