% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

clear all; close all; clc;
%%
K = 0.01;
f = @(t, x) x * exp(-t / 2);
g = @(x) 4 * x .* (x - 1) .* (x - 2);
BC0 = @(t) 0;   % not implemented
BC1 = @(t) 0;   % not implemented

dx = 1 / 100;
T = 2;

names = {'heat1a', 'heat1b', 'heat1c'};
steps = [1 / 60, 1 / 100, 1 / 140];

for i = 1:3
    dt = steps(i);
    [~, n_diff_CN_Ri, ~, n_diff_BE, U_CN, U_Ri, U_BE, U_FE, U_DF, ~, ~, ~] = ...
            heat_solve(K, f, g, BC0, BC1, T, dx, dt, -1, -1, 1);
    close all;
    semilogy(n_diff_CN_Ri, 'r'); hold on; semilogy(n_diff_BE, 'b'); hold off;

    subplot(3, 2, 1); imagesc(U_CN); colorbar(); title('CN');
    subplot(3, 2, 2); imagesc(U_BE); colorbar(); title('BE');
    subplot(3, 2, 3); imagesc(U_FE); colorbar(); title('FE');
    subplot(3, 2, 4); imagesc(U_Ri); colorbar(); title('Ri');
    subplot(3, 2, 5); imagesc(U_DF); colorbar(); title('DF');

    figure
    subplot(2, 1, 1); semilogy(n_diff_CN_Ri); title('CN/Ri');
    subplot(2, 1, 2); semilogy(n_diff_BE); title('BE/FE');
    save(names{i});
end

%%
K = 0.001;
f = @(t, x) x * 0 + (1 - sqrt(1 - 4 * (t - t^2))) / (2 - 2 * t);
g = @(x) 6 * abs(x - 0.5)  - 3;
BC0 = @(t) 0;   % not implemented
BC1 = @(t) 0;   % not implemented

dx = 1 / 200;
T = 1;

names = {'heat2a', 'heat2b', 'heat2c'};
steps = [1 / 100, 1 / 200, 1 / 400];

for i = 1:3
    dt = steps(i);
    [~, n_diff_CN_Ri, ~, n_diff_BE, U_CN, U_Ri, U_BE, U_FE, U_DF, ~, ~, ~] = ...
            heat_solve(K, f, g, BC0, BC1, T, dx, dt, -1, -1, 1);
    close all;
    semilogy(n_diff_CN_Ri, 'r'); hold on; semilogy(n_diff_BE, 'b'); hold off;

    subplot(3, 2, 1); imagesc(U_CN); colorbar(); title('CN');
    subplot(3, 2, 2); imagesc(U_BE); colorbar(); title('BE');
    subplot(3, 2, 3); imagesc(U_FE); colorbar(); title('FE');
    subplot(3, 2, 4); imagesc(U_Ri); colorbar(); title('Ri');
    subplot(3, 2, 5); imagesc(U_DF); colorbar(); title('DF');

    figure
    subplot(2, 1, 1); semilogy(n_diff_CN_Ri); title('CN/Ri');
    subplot(2, 1, 2); semilogy(n_diff_BE); title('BE/FE');
    save(names{i});
end


%%
K = 0.01;
f = @(t, x) 0.1 * (sin(2 * pi * t)  + cos(2 * pi * x));
g = @(x) x .* (x - 1);
BC0 = @(t) 0;   % not implemented
BC1 = @(t) 0;   % not implemented

dx = 1 / 160;
T = 2;

names = {'heat3a', 'heat3b', 'heat3c'};
steps = [1 / 100, 1 / 160, 1 / 200];

for i = 1:3
    dt = steps(i);
    [~, n_diff_CN_Ri, ~, n_diff_BE, U_CN, U_Ri, U_BE, U_FE, U_DF, ~, ~, ~] = ...
            heat_solve(K, f, g, BC0, BC1, T, dx, dt, -1, -1, 1);
    close all;
    semilogy(n_diff_CN_Ri, 'r'); hold on; semilogy(n_diff_BE, 'b'); hold off;

    subplot(3, 2, 1); imagesc(U_CN); colorbar(); title('CN');
    subplot(3, 2, 2); imagesc(U_BE); colorbar(); title('BE');
    subplot(3, 2, 3); imagesc(U_FE); colorbar(); title('FE');
    subplot(3, 2, 4); imagesc(U_Ri); colorbar(); title('Ri');
    subplot(3, 2, 5); imagesc(U_DF); colorbar(); title('DF');

    figure
    subplot(2, 1, 1); semilogy(n_diff_CN_Ri); title('CN/Ri');
    subplot(2, 1, 2); semilogy(n_diff_BE); title('BE/FE');
    save(names{i});
end


