% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function [] = gen_ode_data(mu, dt, sigma, save_file, num_trials, solver, f_type)

rng(27)

% Setup
% Van der Poel Equation

f = @(t,u) [u(2) mu*(1-u(1)^2)*u(2)-u(1)];
u0 = [1 0];
t0 = 0;
T = 14;

start_ind = 12;


if strcmp(solver, 'RK')
    RK_ind45 = randi([1 6], num_trials, 1);
    RK_ind23 = randi([1 4], num_trials, 1);
    space_ind = randi(2, num_trials, 1);
    amt = rnor2(num_trials, sigma);
    time_ind = randi([start_ind, T / dt - 1], num_trials, 1);
    data_RK45 = zeros(num_trials, 6);
    data_RK23 = data_RK45;

    D45 = zeros(num_trials, 1); E45 = D45; F45 = D45;
    D23 = zeros(num_trials, 1); E23 = D23; F23 = D23;    

    fprintf('Progress ')
    tic
    for i = 1:num_trials
        [ ~, ~, n_diff, err, LTE ] = ...
        ode_rk45_FT( u0, t0, T, f, dt, RK_ind45(i), time_ind(i), amt(i), space_ind(i), f_type);
        D45(i) = n_diff(time_ind(i));
        E45(i) = err;
        F45(i) = LTE;

        data_RK45 = update_fault_stats(i, data_RK45, time_ind(i), n_diff, amt(i), space_ind(i));
    
        [ ~, ~, n_diff, err, LTE ] = ...
        ode_rk23_FT( u0, t0, T, f, dt, RK_ind23(i), time_ind(i), amt(i), space_ind(i), f_type);
        D23(i) = n_diff(time_ind(i));
        E23(i) = err;
        F23(i) = LTE;

        data_RK23 = update_fault_stats(i, data_RK23, time_ind(i), n_diff, amt(i), space_ind(i));
        if (~mod(i, 100))
            fprintf('|');
        end    
    end
    fprintf('\n')
    toc
    
    sum(data_RK45(:, 3)) / num_trials
    sum(data_RK45(:, 4)) / sum(data_RK45(:, 1) - start_ind + 1)
    sum(data_RK23(:, 3)) / num_trials
    sum(data_RK23(:, 4)) / sum(data_RK45(:, 1) - start_ind + 1)
    LTE_vis_RK(data_RK45, D45, E45, F45, mu, 1 / dt, 'test', 1e-2, 'RK45');
    LTE_vis_RK(data_RK23, D23, E23, F23, mu, 1 / dt, 'test', 1e-2, 'RK23');
    
elseif strcmp(solver, 'AB')
    AB_ind45 = randi([1 4], num_trials, 1);
    AB_ind23 = randi([1 2], num_trials, 1);    
    space_ind = randi(2, num_trials, 1);
    amt = rnor2(num_trials, sigma);
    time_ind = randi([start_ind, T / dt - 1], num_trials, 1);
    data_AB45 = zeros(num_trials, 6);
    data_AB23 = data_AB45;

    D45 = zeros(num_trials, 1); E45 = D45; F45 = D45;
    D23 = zeros(num_trials, 1); E23 = D23; F23 = D23;    

    fprintf('Progress ')
    tic
    for i = 1:num_trials
        [ ~, ~, n_diff, err, LTE ] = ...
        ode_ab45_FT( u0, t0, T, f, dt, AB_ind45(i), time_ind(i), amt(i), space_ind(i), f_type);
        D45(i) = n_diff(time_ind(i));
        E45(i) = err;
        F45(i) = LTE;

        data_AB45 = update_fault_stats(i, data_AB45, time_ind(i), n_diff, amt(i), space_ind(i));
    
        [ ~, ~, n_diff, err, LTE ] = ...
        ode_ab23_FT( u0, t0, T, f, dt, AB_ind23(i), time_ind(i), amt(i), space_ind(i), f_type);
        D23(i) = n_diff(time_ind(i));
        E23(i) = err;
        F23(i) = LTE;

        data_AB23 = update_fault_stats(i, data_AB23, time_ind(i), n_diff, amt(i), space_ind(i));
        if (~mod(i, 100))
            fprintf('|');
        end    
    end
    fprintf('\n')
    toc
    
    sum(data_AB45(:, 3)) / num_trials
    sum(data_AB45(:, 4)) / sum(data_AB45(:, 1) - start_ind + 1)
    sum(data_AB23(:, 3)) / num_trials
    sum(data_AB23(:, 4)) / sum(data_AB45(:, 1) - start_ind + 1)
    LTE_vis_RK(data_AB45, D45, E45, F45, mu, 1 / dt, 'test', 1e-2, 'AB45');
    LTE_vis_RK(data_AB23, D23, E23, F23, mu, 1 / dt, 'test', 1e-2, 'AB23');
else
    fprintf('Unknown solver!\n');
     return
end


save(save_file)
%figure
%plot(Times, U(:, 1), 'b', Times, U(:, 2), 'r');

