% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function [rk4_update, rk5_update] = faulty_rk45(f, t, u, h, i, t_fault, fault_amt, x_fault, ind)

    f1 = f(t, u);
    if (i == t_fault && ind == 1)
        f1(x_fault) = f1(x_fault) * fault_amt;
    end
    k1 = h*f1;
    
    f2 = f(t+h/4, u+k1/4);
    if (i == t_fault && ind == 2)
        f2(x_fault) = f2(x_fault) * fault_amt;
    end    
    k2 = h*f2;
    
    f3 = f(t+3/8*h, u+3/32*k1+9/32*k2);
    if (i == t_fault && ind == 3)
        f3(x_fault) = f3(x_fault) * fault_amt;
    end    
    k3 = h*f3;
    
    f4 = f(t+12/13*h, u+1932/2197*k1-7200/2197*k2+7296/2197*k3);
    if (i == t_fault && ind == 4)
        f4(x_fault) = f4(x_fault) * fault_amt;
    end    
    k4 = h*f4;
    
    f5 = f(t+h, u+439/216*k1-8*k2+3680/513*k3-845/4104*k4);
    if (i == t_fault && ind == 5)
        f5(x_fault) = f5(x_fault) * fault_amt;
    end    
    k5 = h*f5;
    
    f6 = f(t+h/2, u-8/27*k1+2*k2-3544/2565*k3+1859/4104*k4-11/40*k5);
    if (i == t_fault && ind == 6)
        f6(x_fault) = f6(x_fault) * fault_amt;
    end    
    k6 = h*f6;
    
    % calculate updates
    rk4_update = 25/216*k1 + 1408/2565*k3 + 2197/4104*k4-1/5*k5;
    rk5_update = 16/135*k1 + 6656/12825*k3 + 28561/56430*k4-9/50*k5+2/55*k6;
    
end