% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function [rk2_update, rk3_update] = faulty_rk23(f, t, u, h, i, t_fault, fault_amt, x_fault, ind)

f1 = f(t, u);
if (i == t_fault && ind == 1)
  f1(x_fault) = f1(x_fault) * fault_amt;
end    
k1 = h * f1;

f2 = f(t+h/2, u + k1/2);
if (i == t_fault && ind == 2)
  f2(x_fault) = f2(x_fault) * fault_amt;
end    
k2 = h * f2;


f3 = f(t+3/4*h, u + 3/4*k2);
if (i == t_fault && ind == 3)
  f3(x_fault) = f3(x_fault) * fault_amt;
end    
k3 = h * f3;

rk3_update = 2/9*k1 +1/3*k2 + 4/9*k3;

f4 = f(t + h, u + rk3_update);
if (i == t_fault && ind == 4)
  f4(x_fault) = f4(x_fault) * fault_amt;
end    
k4 = h * f4;

rk2_update = 7/24*k1 + 1/4*k2 + 1/3*k3 + 1/8*k4;

