% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function [ y_hat ] = dynkreg( x, y, x_hat, sigma )
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

y_hat = x_hat;

for i = 1:length(x_hat)
    y_hat(i) = sum(y.*lap_kernel(x-x_hat(i),sigma.*x)) ...
            /sum(lap_kernel(x-x_hat(i),sigma.*x));
end
end

function [ k ] = gauss_kernel( x, sigma )
k = exp(-x.^2./(2*sigma.^2));
end

function [ k ] = lap_kernel( x, sigma )
k = exp(-abs(x)./sigma);
end