% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

%%
sigma = 5e-5;
load('heat2b');
num_trials = 2000;

[data_CN_2b_jump, data_BE_2b_jump, E_2b_jump, F_2b_jump] = run_heat_exp('heat2b', num_trials, 'RHS_overall', sigma);
x_loc = 3; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 6;
LTE_visk_heat(data_BE_2b_jump, E_2b_jump(:, 2), F_2b_jump(:, 2), 1 / dx, 1 / dt, 'jump_only', x_loc, y_loc, sigma_kr, xmin, xmax, 1);
%E_BE_2b_jump = E_2b_jump(:, 1); clear E_2b_jump;
%F_BE_2b_jump = F_2b_jump(:, 1); clear F_2b_jump;

%%
[data_CN_2b_var, data_BE_2b_var, E_2b_var, F_2b_var] = run_heat_exp('heat2b', num_trials, 'RHS_overall', sigma);
x_loc = 3; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 6;
LTE_visk_heat(data_BE_2b_var, E_2b_var(:, 2), F_2b_var(:, 2), 1 / dx, 1 / dt, 'jump_only', x_loc, y_loc, sigma_kr, xmin, xmax, 1);


%%
save('detector_results');