% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function [ error_itr ] = analyseq( seq )
% parameters for tuning
c1 = 1.0;
c2 = 1.0;
d1 = 0.95;
d2 = 1.4;
p = 10;

assert(d1 < 1 && 1 < d2);

error_itr = [];
% xs = [];
% ys =[];
% c1s = [];
% c2s = [];

% loop over sequence: find errors online
for n = 11:length(seq)-1
    x = (seq(n+1)-seq(n))/seq(n);
    y = var(seq(n-p:n+1))/var(seq(n-p:n));
    if 1
    if (x > c1 && y > c2)
        error_itr = [error_itr n+1];
    end
    end
    
    if 0
    if (x > c1)
        error_itr = [error_itr n+1];
    end
    end
    
    if 0
    if (y > c2)
        error_itr = [error_itr n+1];
    end
    end
    
    if (x > c1)
        c1 = c1 * d2;
    else
        c1 = c1 * d1;
    end
    if (y > c2)
        c2 = c2 * d2;
    else
        c2 = c2 * d1;
    end
%     xs = [xs x];
%     ys = [ys y];
%     c1s = [c1s c1];
%     c2s = [c2s c2];
end

% figure(1); clf;
% subplot(1,3,1)
% plot(1:length(seq),seq,'bx-')
% hold on
% plot(error_itr,seq(error_itr),'ro')
% xlabel('iteration')
% ylabel('difference between methods')
% 
% subplot(1,3,2)
% hold on
% plot(abs(xs), 'b.')
% plot(c1s, 'black-')
% subplot(1,3,3)
% hold on
% plot(ys, 'r.')
% plot(c2s, 'black-')

end
