% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

%%
clear all;
num_trials = 2000;
close all;
fault_type = 'f_eval';


% Crank-Nicolson
if 1
sigma = 1e-3;

% 1a
[data_CN_1a, ~, E_1a, F_1a] = run_heat_exp('heat1a', num_trials, fault_type, sigma);
E_CN_1a = E_1a(:, 1); clear E_1a;
F_CN_1a = F_1a(:, 1); clear F_1a;
figure; semilogy(sort(E_CN_1a ./ F_CN_1a));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat1a'); close all;
LTE_visk_heat(data_CN_1a, E_CN_1a, F_CN_1a, 1 / dx, 1 / dt, 'heat1a_CN', x_loc, y_loc, sigma_kr, xmin, xmax, 0);

% 1b
[data_CN_1b, ~, E_1b, F_1b] = run_heat_exp('heat1b', num_trials, fault_type, sigma);
E_CN_1b = E_1b(:, 1); clear E_1b;
F_CN_1b = F_1b(:, 1); clear F_1b;
figure; semilogy(sort(E_CN_1b ./ F_CN_1b));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat1b'); close all;
LTE_visk_heat(data_CN_1b, E_CN_1b, F_CN_1b, 1 / dx, 1 / dt, 'heat_1b_CN', x_loc, y_loc, sigma_kr, xmin, xmax, 0);

% 1c
[data_CN_1c, ~, E_1c, F_1c] = run_heat_exp('heat1c', num_trials, fault_type, sigma);
E_CN_1c = E_1c(:, 1); clear E_1c;
F_CN_1c = F_1c(:, 1); clear F_1c;
figure; semilogy(sort(E_CN_1c ./ F_CN_1c));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat1c'); close all;
LTE_visk_heat(data_CN_1c, E_CN_1c, F_CN_1c, 1 / dx, 1 / dt, 'heat_1c_CN', x_loc, y_loc, sigma_kr, xmin, xmax, 0);
end

% Backward Euler
if 1
sigma = 1e-1;

% 1a
[~, data_BE_1a, E_1a, F_1a] = run_heat_exp('heat1a', num_trials, fault_type, sigma);
E_BE_1a = E_1a(:, 2); clear E_1a;
F_BE_1a = F_1a(:, 2); clear F_1a;
figure; semilogy(sort(E_BE_1a ./ F_BE_1a));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat1a');
LTE_visk_heat(data_BE_1a, E_BE_1a, F_BE_1a, 1 / dx, 1 / dt, 'heat_1a_BE', x_loc, y_loc, sigma_kr, xmin, xmax, 1);

% 1b
[~, data_BE_1b, E_1b, F_1b] = run_heat_exp('heat1b', num_trials, fault_type, sigma);
E_BE_1b = E_1b(:, 2); clear E_1b;
F_BE_1b = F_1b(:, 2); clear F_1b;
figure; semilogy(sort(E_BE_1b ./ F_BE_1b));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat1b');
LTE_visk_heat(data_BE_1b, E_BE_1b, F_BE_1b, 1 / dx, 1 / dt, 'heat_1b_BE', x_loc, y_loc, sigma_kr, xmin, xmax, 1);


% 1c
[~, data_BE_1c, E_1c, F_1c] = run_heat_exp('heat1c', num_trials, fault_type, sigma);
E_BE_1c = E_1c(:, 2); clear E_1c;
F_BE_1c = F_1c(:, 2); clear F_1c;
figure; semilogy(sort(E_BE_1c ./ F_BE_1c));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat1c');
LTE_visk_heat(data_BE_1c, E_BE_1c, F_BE_1c, 1 / dx, 1 / dt, 'heat_1c_BE', x_loc, y_loc, sigma_kr, xmin, xmax, 1);
end

save('heat_results_part1');

%%
clear all;
num_trials = 2000;
close all;
fault_type = 'RHS_overall';


% Crank-Nicolson
if 1
sigma = 1e-6;

% 2a
if 1
[data_CN_2a, ~, E_2a, F_2a] = run_heat_exp('heat2a', num_trials, fault_type, sigma);
E_CN_2a = E_2a(:, 1); clear E_2a;
F_CN_2a = F_2a(:, 1); clear F_2a;
figure; semilogy(sort(E_CN_2a ./ F_CN_2a));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat2a'); close all;
LTE_visk_heat(data_CN_2a, E_CN_2a, F_CN_2a, 1 / dx, 1 / dt, 'heat_2a_CN', x_loc, y_loc, sigma_kr, xmin, xmax, 0);
end

% 2b
if 1
[data_CN_2b, ~, E_2b, F_2b] = run_heat_exp('heat2b', num_trials, fault_type, sigma);
E_CN_2b = E_2b(:, 1); clear E_2b;
F_CN_2b = F_2b(:, 1); clear F_2b;
figure; semilogy(sort(E_CN_2b ./ F_CN_2b));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat2b'); close all;
LTE_visk_heat(data_CN_2b, E_CN_2b, F_CN_2b, 1 / dx, 1 / dt, 'heat_2b_CN', x_loc, y_loc, sigma_kr, xmin, xmax, 0);
end

% 2c
if 1
[data_CN_2c, ~, E_2c, F_2c] = run_heat_exp('heat2c', num_trials, fault_type, sigma);
E_CN_2c = E_2c(:, 1); clear E_2c;
F_CN_2c = F_2c(:, 1); clear F_2c;
figure; semilogy(sort(E_CN_2c ./ F_CN_2c));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat2c'); close all;
LTE_visk_heat(data_CN_2c, E_CN_2c, F_CN_2c, 1 / dx, 1 / dt, 'heat_2c_CN', x_loc, y_loc, sigma_kr, xmin, xmax, 0);
end

end

% Backward Euler
if 1
sigma = 5e-5;

% 2a
if 1
[~, data_BE_2a, E_2a, F_2a] = run_heat_exp('heat2a', num_trials, fault_type, sigma);
E_BE_2a = E_2a(:, 2); clear E_2a;
F_BE_2a = F_2a(:, 2); clear F_2a;
    semilogy(sort(E_BE_2a ./ F_BE_2a));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat2a');
LTE_visk_heat(data_BE_2a, E_BE_2a, F_BE_2a, 1 / dx, 1 / dt, 'heat_2a_BE', x_loc, y_loc, sigma_kr, xmin, xmax, 1);
end

% 2b
if 1
[~, data_BE_2b, E_2b, F_2b] = run_heat_exp('heat2b', num_trials, fault_type, sigma);
E_BE_2b = E_2b(:, 2); clear E_2b;
F_BE_2b = F_2b(:, 2); clear F_2b;
figure; semilogy(sort(E_BE_2b ./ F_BE_2b));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat2b');
LTE_visk_heat(data_BE_2b, E_BE_2b, F_BE_2b, 1 / dx, 1 / dt, 'heat_2b_BE', x_loc, y_loc, sigma_kr, xmin, xmax, 1);
end

% 2c
if 1
[~, data_BE_2c, E_2c, F_2c] = run_heat_exp('heat2c', num_trials, fault_type, sigma);
E_BE_2c = E_2c(:, 2); clear E_2c;
F_BE_2c = F_2c(:, 2); clear F_2c;
figure; semilogy(sort(E_BE_2c ./ F_BE_2c));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat2c');
LTE_visk_heat(data_BE_2c, E_BE_2c, F_BE_2c, 1 / dx, 1 / dt, 'heat_2c_BE', x_loc, y_loc, sigma_kr, xmin, xmax, 1);
end

end

save('heat_results_part2');

%%
clear all;
num_trials = 2000;
close all;
fault_type = 'prev_soln';


% Crank-Nicolson
if 0
sigma = 1e-6;

% 3a
if 1
[data_CN_3a, ~, E_3a, F_3a] = run_heat_exp('heat3a', num_trials, fault_type, sigma);
E_CN_3a = E_3a(:, 1); clear E_3a;
F_CN_3a = F_3a(:, 1); clear F_3a;
figure; semilogy(sort(E_CN_3a ./ F_CN_3a));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat3a'); close all;
LTE_visk_heat(data_CN_3a, E_CN_3a, F_CN_3a, 1 / dx, 1 / dt, 'heat_3a_CN', x_loc, y_loc, sigma_kr, xmin, xmax, 0);
end

% 3b
if 1
[data_CN_3b, ~, E_3b, F_3b] = run_heat_exp('heat3b', num_trials, fault_type, sigma);
E_CN_3b = E_3b(:, 1); clear E_3b;
F_CN_3b = F_3b(:, 1); clear F_3b;
figure; semilogy(sort(E_CN_3b ./ F_CN_3b));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat3b'); close all;
LTE_visk_heat(data_CN_3b, E_CN_3b, F_CN_3b, 1 / dx, 1 / dt, 'heat_3b_CN', x_loc, y_loc, sigma_kr, xmin, xmax, 0);
end

% 3c
if 1
[data_CN_3c, ~, E_3c, F_3c] = run_heat_exp('heat3c', num_trials, fault_type, sigma);
E_CN_3c = E_3c(:, 1); clear E_3c;
F_CN_3c = F_3c(:, 1); clear F_3c;
figure; semilogy(sort(E_CN_3c ./ F_CN_3c));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat3c'); close all;
LTE_visk_heat(data_CN_3c, E_CN_3c, F_CN_3c, 1 / dx, 1 / dt, 'heat_3c_CN', x_loc, y_loc, sigma_kr, xmin, xmax, 0);
end

end

% Backward Euler
if 1
sigma = 1e-4;

% 3a
if 1
[~, data_BE_3a, E_3a, F_3a] = run_heat_exp('heat3a', num_trials, fault_type, sigma);
E_BE_3a = E_3a(:, 2); clear E_3a;
F_BE_3a = F_3a(:, 2); clear F_3a;
semilogy(sort(E_BE_3a ./ F_BE_3a));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat3a');
LTE_visk_heat(data_BE_3a, E_BE_3a, F_BE_3a, 1 / dx, 1 / dt, 'heat_3a_BE', x_loc, y_loc, sigma_kr, xmin, xmax, 1);
end

% 3b
if 1
[~, data_BE_3b, E_3b, F_3b] = run_heat_exp('heat3b', num_trials, fault_type, sigma);
E_BE_3b = E_3b(:, 2); clear E_3b;
F_BE_3b = F_3b(:, 2); clear F_3b;
figure; semilogy(sort(E_BE_3b ./ F_BE_3b));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat3b');
LTE_visk_heat(data_BE_3b, E_BE_3b, F_BE_3b, 1 / dx, 1 / dt, 'heat_3b_BE', x_loc, y_loc, sigma_kr, xmin, xmax, 1);
end

% 3c
if 1
[~, data_BE_3c, E_3c, F_3c] = run_heat_exp('heat3c', num_trials, fault_type, sigma);
E_BE_3c = E_3c(:, 2); clear E_3c;
F_BE_3c = F_3c(:, 2); clear F_3c;
figure; semilogy(sort(E_BE_3c ./ F_BE_3c));

x_loc = 0.5; y_loc = 0.2; sigma_kr = 0.3; xmin = 1e-2; xmax = 3;
load('heat3c');
LTE_visk_heat(data_BE_3c, E_BE_3c, F_BE_3c, 1 / dx, 1 / dt, 'heat_3c_BE', x_loc, y_loc, sigma_kr, xmin, xmax, 1);
end

end

save('heat_results_part3');
