% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function LTE_visk_heat_overlay(data, E, F, dx, dt, out_file, x_loc, y_loc, sigma_kr, ...
     xmin, xmax, type, use_leg, data2, E2, F2)
 
LTEs = E ./ F;

[~, I1] = sort(LTEs); LTEs = LTEs(I1);
data = data(I1, :);

FPR = sum(data(:, 4)) / sum(data(:, 1) - 11);

x = linspace(xmin, xmax, 1000);

% figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
width = 6;     % Width in inches
height = 3;    % Height in inches
alw = 0.75;    % AxesLineWidth
fsz = 9;      % Fontsize
lw = 1.75;      % LineWidth
msz = 8;       % MarkerSize
%%%%%%%%%%%%%%%%%%%%%%%%%%

% set figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf, 'Position', [pos(1) pos(2) width*100, height*100]); %<- Set size
set(gca, 'FontSize', fsz, 'LineWidth', alw); %<- Set properties
%%%%%%%%%%%%%%%%%%%%%%%%%


detected = 1-(data(:, 3) == 0);
detected_im = (data(:, 3) == 1 & data(:, 5) ~= 1);
figure;
plot(x, kreg(LTEs, detected_im, x, sigma_kr), 'r--', ...
    x, kreg(LTEs, detected, x, sigma_kr), 'b-', 'LineWidth', lw); hold on;

data = data2;
E = E2;
F = F2;
LTEs = E ./ F;
[~, I1] = sort(LTEs); LTEs = LTEs(I1);
data = data(I1, :);

detected = 1-(data(:, 3) == 0);
detected_im = (data(:, 3) == 1 & data(:, 5) ~= 1);

lw = 0.75;
x = linspace(xmin, xmax, 1000);
plot(x, kreg(LTEs, detected_im, x, sigma_kr), 'm--', ...
    x, kreg(LTEs, detected, x, sigma_kr), 'g-', 'LineWidth', lw); hold off;


axis([xmin xmax 0 1]);

xlabel('LTE-normalized Error');
ylabel('True positive rate');
title(sprintf('FE/BE, {\\Delta}x = 1 / %d, {\\Delta}t = 1 / %d (%s only)', dx, dt, type));
if (use_leg)
    legend(sprintf('Detected at step of fault (%s only)', type), ...
        sprintf('Detected at step or step after fault (%s only)', type), ...
        'Detected at step of fault (jump and var)', ...
        'Detected at step or step after fault (jump and var)', ...
        'Location', 'SouthEast');
end

text(x_loc, y_loc, sprintf('FPR = %0.3f', FPR));

%set(findall(gcf,'type','text'),'fontSize', fsz);

% set more parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'InvertHardcopy','on');
set(gcf,'PaperUnits', 'inches');
papersize = get(gcf, 'PaperSize');
left = (papersize(1)- width)/2;
bottom = (papersize(2)- height)/2;
myfiguresize = [left, bottom, width, height];
set(gcf,'PaperPosition', myfiguresize);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

