% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function LTE_visk(data_CN, data_BE, D, E, F, dx, dt, out_file, y_locs, sigma, xmax) %#ok<INUSL>

LTEs = E ./ F;

[~, I1] = sort(LTEs(:, 1)); LTEs(:, 1) = LTEs(I1, 1);
[~, I2] = sort(LTEs(:, 2)); LTEs(:, 2) = LTEs(I2, 2);
data_CN = data_CN(I1, :);
data_BE = data_BE(I2, :);

xmin = 0;
x = linspace(xmin, xmax, 1000);

fsz = 12;
figure;
subplot(2,1,1); hold on



detected = 1 - (data_BE(:, 3) == 0);
detected_im = (data_BE(:, 3) == 1 & data_BE(:, 5) ~= 1);

plot(x, kreg(LTEs(:, 2), detected_im, x, sigma), 'b-'); 
plot(x, kreg(LTEs(:, 2), detected, x, sigma), 'r-'); hold off;
axis([xmin xmax 0 1]);

xlabel('LTE-normalized Error');
ylabel('True positive rate');
title(sprintf('Backward / Forward Euler. dx = 1 / %d, dt = 1 / %d.', dx, dt));
legend('Detected at step of fault', 'Detected at step or step after fault', 'Location', 'SouthEast');

NTRIALS = size(data_BE, 1);
TPR = sum(data_BE(:, 3)) / NTRIALS;
FPR = sum(data_BE(:, 4)) / sum(data_BE(:, 1) - 11);
x_loc = 200;
%y_loc = LTEs(20, 2) * y_scale;
y_loc = y_locs(1);
text(x_loc, y_loc, sprintf('TPR = %0.3f\nFPR = %0.3f', TPR, FPR));
subplot(2,1,2); hold on

detected = 1-(data_CN(:, 3) == 0);
detected_im = (data_CN(:, 3) == 1 & data_CN(:, 5) ~= 1);

plot(x, kreg(LTEs(:, 2), detected_im, x, sigma), 'b-'); 
plot(x, kreg(LTEs(:, 2), detected, x, sigma), 'r-'); hold off;
axis([xmin xmax 0 1]);

xlabel('LTE-normalized Error');
ylabel('True positive rate');
title(sprintf('Crank-Nicolson / Richardson. dx = 1 / %d, dt = 1 / %d.', dx, dt));
legend('Detected at step of fault', 'Detected at step or step after fault', 'Location', 'SouthEast');

NTRIALS = size(data_CN, 1);
TPR = sum(data_CN(:, 3)) / NTRIALS;
FPR = sum(data_CN(:, 4)) / sum(data_CN(:, 1) - 11);
x_loc = 200;
%y_loc = LTEs(20, 1) * y_scale;
y_loc = y_locs(2);
text(x_loc, y_loc, sprintf('TPR = %0.3f\nFPR = %0.3f', TPR, FPR));

set(findall(gcf,'type','text'),'fontSize', fsz);

saveplotaspdf(out_file, 7,7);