% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function LTE_vis_RK(data_RK, D, E, F, mu, dt, out_file, y_loc, method, use_leg)
LTEs = E ./ F;

[~, I1] = sort(LTEs); LTEs = LTEs(I1);
data_RK = data_RK(I1, :);

fsz = 12;

xmax = 1000;
xmin = 0.5;
x = linspace(log(xmin), log(xmax), 1000);
x = exp(x);
sigma = 0.3;

fsz = 12;
figure(2);


% figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
width = 3.5;     % Width in inches
height = 2.25;    % Height in inches
alw = 0.75;    % AxesLineWidth
fsz = 9;      % Fontsize
lw = 1.5;      % LineWidth
msz = 8;       % MarkerSize
%%%%%%%%%%%%%%%%%%%%%%%%%%

% set figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf, 'Position', [pos(1) pos(2) width*100, height*100]); %<- Set size
set(gca, 'FontSize', fsz, 'LineWidth', alw); %<- Set properties
%%%%%%%%%%%%%%%%%%%%%%%%%


% Have to fix these two
detected = 1-(data_RK(:, 3) == 0);
deteced_im = (data_RK(:, 3) == 1 & data_RK(:, 5) ~= 1);

semilogx(x, dynkreg(LTEs, deteced_im, x, sigma), 'r--', ...
    x, dynkreg(LTEs, detected, x, sigma), 'b-', ...
    'LineWidth',lw);
axis([0 xmax 0 1]);

% inds0 = find(data_RK(:, 3) == 0);
% semilogy(inds0, LTEs(inds0), 'ro', 'MarkerSize', 8); hold on;
% 
% inds1 = find(data_RK(:, 3) == 1 & data_RK(:, 5) ~= 1);
% semilogy(inds1, LTEs(inds1), 'b.'); hold on;
% 
% inds1 = find(data_RK(:, 3) == 1 & data_RK(:, 5) == 1);
% semilogy(inds1, LTEs(inds1), 'g*', 'MarkerSize', 6); hold off;

xlabel('LTE-normalized Error');
ylabel('True positive rate');
title(sprintf('%s on Van der Pol with h = 1 / %d, b = %d', method, dt, mu));
if (use_leg)
    legend('Detected at step of fault', 'Detected at step or step after fault', 'Location', 'SouthEast');
end

%NTRIALS = size(data_RK, 1);
%TPR = sum(data_RK(:, 3)) / NTRIALS;
FPR = sum(data_RK(:, 4)) / sum(data_RK(:, 1) - 11);
%x_loc = 200;
% We would have to move this
%text(x_loc, y_loc, sprintf('TPR = %0.3f\nFPR = %0.3f', TPR, FPR));
text(10^2 - 200, y_loc, sprintf('FPR = %0.3f', FPR));

%set(findall(gcf,'type','text'),'fontSize', fsz);

% set more parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'InvertHardcopy','on');
set(gcf,'PaperUnits', 'inches');
papersize = get(gcf, 'PaperSize');
left = (papersize(1)- width)/2;
bottom = (papersize(2)- height)/2;
myfiguresize = [left, bottom, width, height];
set(gcf,'PaperPosition', myfiguresize);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%


