% This experimental code is published in connection with a scientific publication, Silent error detection in numerical time-stepping schemes,
% by Austin R. Benson, Sven Schmit, and Robert Schreiber, to appear in International Journal of High Performance Computing Applications in 2014.
% This code is made available solely to allow the readers of that publication to verify and reproduce the results described. 
% This experimental code is published "as is", with no representation, warranty, indemnification of any kind. 
% Hewlett-Packard excludes all liability that may result from the use of this experimental code in any form.

function LTE_vis_NS(data_RK, E, F, dt, out_file, y_loc, Re, use_leg)

LTEs = E ./ F;

[~, I1] = sort(LTEs); LTEs = LTEs(I1);
data_RK = data_RK(I1, :);

% figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
width = 6;     % Width in inches
height = 3;    % Height in inches
alw = 0.75;    % AxesLineWidth
fsz = 10;      % Fontsize
lw = 1.5;      % LineWidth
msz = 8;       % MarkerSize
%%%%%%%%%%%%%%%%%%%%%%%%%%

% set figure parameters
%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf, 'Position', [pos(1) pos(2) width*100, height*100]); %<- Set size
set(gca, 'FontSize', fsz, 'LineWidth', alw); %<- Set properties
%%%%%%%%%%%%%%%%%%%%%%%%%

xmin = 0.1;
xmax = 2;
x = linspace(xmin,xmax,1000);
sigma = 0.05;


detected = 1-(data_RK(:, 3) == 0);
detected_im = (data_RK(:, 3) == 1 & data_RK(:, 5) ~= 1);

plot(x, kreg(LTEs, detected_im, x, sigma), 'r--', ...
    x, kreg(LTEs, detected, x, sigma), 'b-', 'LineWidth', lw);
axis([0 xmax 0 1]);

% 
% inds0 = find(data_RK(:, 3) == 0);
% semilogy(inds0, LTEs(inds0), 'ro', 'MarkerSize', 8); hold on;
% 
% inds1 = find(data_RK(:, 3) == 1 & data_RK(:, 5) ~= 1);
% semilogy(inds1, LTEs(inds1), 'b.'); hold on;
% 
% inds1 = find(data_RK(:, 3) == 1 & data_RK(:, 5) == 1);
% semilogy(inds1, LTEs(inds1), 'g*', 'MarkerSize', 6); hold off;

xlabel('LTE-normalized Error');
ylabel('True positive rate');
title(sprintf('Incompressible Navier-Stokes equations, Re = %d', Re));
if (use_leg)
    legend('Detected at step of fault', 'Detected at step or step after fault', 'Location', 'Best');
end

NTRIALS = size(data_RK, 1);
%TPR = sum(data_RK(:, 3)) / NTRIALS;
FPR = sum(data_RK(:, 4)) / sum(data_RK(:, 1) - 11);
x_loc = 0.1; y_loc = 0.7;
text(x_loc, y_loc, sprintf('FPR = %0.3f', FPR));

% set more parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(gcf,'InvertHardcopy','on');
set(gcf,'PaperUnits', 'inches');
papersize = get(gcf, 'PaperSize');
left = (papersize(1)- width)/2;
bottom = (papersize(2)- height)/2;
myfiguresize = [left, bottom, width, height];
set(gcf,'PaperPosition', myfiguresize);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

