/*
 * tocxPkg.cpp -- 
 * 
 *      Initializes the Tocx package.
 *
 * Copyright (c) 1997 Cornell University.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * 
 */

#include "stdafx.h"
#include "tocxInt.h"

static void		ExitProc _ANSI_ARGS_((ClientData clientData));


/*
 *----------------------------------------------------------------------
 * Tocx_SafeInit --
 *
 *      Entry point for dynamically loading this library into a safe
 *      interpreter.
 *
 * Results:
 *      Same as Tocx_Init().
 *
 * Side effects:
 *      Same as Tocx_Init().
 *----------------------------------------------------------------------
 */

extern "C" __declspec( dllexport ) int
Tocx_SafeInit(
    Tcl_Interp *interp)		/* Current interperter. */
{
    return Tocx_Init(interp);
}

/*
 *----------------------------------------------------------------------
 * Tocx_SafeInit --
 *
 *      Entry point for dynamically loading this library into a (unsafe).
 *      interpreter.
 *
 * Results:
 *      Standard Tcl result.
 *
 * Side effects:
 *      Tocx commands are registered.
 *----------------------------------------------------------------------
 */

extern "C"__declspec( dllexport ) int
Tocx_Init(
    Tcl_Interp *interp)		/* Current interperter. */
{
    HRESULT hr;

    /*
     * Initialize OLE , if necessary
     */

    hr = OleInitialize(NULL);

    if (hr != S_OK && hr != S_FALSE) {
        Tcl_AppendResult(interp, "tocx initialization failed: ",
                Tocx_ErrorCode(hr), (char*)NULL);
        return TCL_ERROR;
    } else {
        Tcl_CreateExitHandler(ExitProc, (ClientData)NULL);
    }


    Tcl_CreateCommand(interp, "tocx_info", Tocx_InfoCmd,
            (ClientData) Tk_MainWindow(interp), (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "tocx", Tocx_TocxCmd,
            (ClientData) Tk_MainWindow(interp), (Tcl_CmdDeleteProc *) NULL);

    Tcl_PkgProvide(interp, "tocx", "0.9");

    return TCL_OK;
}

/*
 *----------------------------------------------------------------------
 * ExitProc --
 *
 *      Cleans up when the Tcl application exits.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      tocx may be uninitialized.
 *----------------------------------------------------------------------
 */

static void
ExitProc(
    ClientData clientData)	/* Ignored. */
{
    /*
     * OLE *may* be uninitialized after this call. If OleInitialize()
     * was called more than once (by another module outside of Tocx).,
     * OLE will be uninitialized at the call of OleUninitialize that matches
     * the number of OleInitialize() calls.
     */
    OleUninitialize();
}
