/*
 * tocxMfc.cpp -- 
 * 
 *      Declarations of MFC related prototypes.
 *
 *	Note: This file will be purged once all functionalities are migrated
 *	to a non-MFC implementation of Tocx.
 *
 * Copyright (c) 1997 Cornell University.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * 
 */

#ifndef TOCX_MFC_H
#define TOCX_MFC_H

#ifndef TOCX_INT_H
#include "tocxInt.h"
#endif

class CtocxObject : public CWnd {
protected:
    DECLARE_DYNCREATE(CtocxObject)
public:
    TocxMethodInfo *funcHead;	/* List of methods. */
    TocxMethodInfo *funcTail;
    TocxPropertyInfo *propHead;	/* List of properties */
    TocxPropertyInfo *propTail;
    TocxEventInfo *eventHead;	/* List of events */
    TocxEventInfo *eventTail;
    TocxEventBinding *bindList;	/* List of event bindings. */
    TocxTypeInfo *		/* List of type informations. */
	typeInfoList;

    Tk_Window tkwin;		/* Tk window associated with OCX */
    CWnd *parent;		/* CWnd represntation of the OCX's parent
				 * window. Refers to the same HWnd as
				 * TkWindowId(tkwin) */
    Tcl_Interp * interp;	/* Interpreter associated with OCX. */
    Tcl_Command widgetCmd;	/* Token for OCX's widget command. */
    int width, height;		/* Size of the widget */
    LPDISPATCH m_pdisp;		/* The IDispatch interface of the OCX. */

    /*
     * Virtual function overrides.
     */
    virtual BOOL Create(
	LPCTSTR lpszClassName,
	LPCTSTR lpszWindowName,
	DWORD dwStyle,
	const RECT& rect,
	CWnd* pParentWnd,
	UINT nID,
	CCreateContext* pContext = NULL)
    {
	return CreateControl(lpszClassName, lpszWindowName, dwStyle, rect,
		pParentWnd, nID);
    }
    virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra,
	    AFX_CMDHANDLERINFO* pHandlerInfo);

    TocxTypeInfo * InterpretTypeDesc(LPTYPEINFO pTypeInfo, TYPEDESC * desc);
    void InterpretTypeDescHelper(LPTYPEINFO pTypeInfo,
			    TYPEDESC* tdesc, int aliasCount,
			    TocxTypeInfo * tiPtr);
    void MakeAliasConverter(LPTYPEINFO pTypeInfo, LPTYPEATTR pTypeAttr,
			    TocxTypeInfo * tiPtr);
    void MakeDispatchConverter(LPTYPEINFO pTypeInfo, LPTYPEATTR pTypeAttr,
			    TocxTypeInfo * tiPtr);
    void MakeEnumConverter(LPTYPEINFO pTypeInfo, LPTYPEATTR pTypeAttr,
			    TocxTypeInfo * tiPtr);
    TocxFuncInfo * MakeFuncInfo(LPTYPEINFO pTypeInfo, FUNCDESC * desc);

    /*
     * Functions used in this class.
     */
    void		AddProperty(LPTYPEINFO pTypeInfo, BSTR bstrName,
			    MEMBERID memid, VARDESC *vDesc,
			    FUNCDESC *fDesc, int indexed);

    HRESULT		GetClassInfo(ITypeInfo **classInfo);
    HRESULT		GetDispatchInfo(ITypeInfo *pClassInfo,
			    ITypeInfo **typeInfo, int mask);
    int			UpdateInfoTable();
};

#endif /* TOCX_MFC_H */
