/*
 * tocxInt.h --
 *
 *	Internal header file used by the Tk ocx widget.
 *
 * Copyright (c) 1995-1996 Cornell University.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#ifndef TOCX_INT_H
#define TOCX_INT_H

#ifndef TOCX_H
#include "tocx.h"
#endif

/*
 * Stores information about an OLE funtion.
 *
 * NOTE: This data structure does not pertain to OLE *method* only. OLE
 * functions may be related to Methods, Properties (as get/set functions)
 * and Events (as an event function).
 */

typedef struct TocxFuncInfo {
    FUNCDESC * desc;		/* FUNCDESC of the function. */
    TocxTypeInfo * type;	/* Return type. */
    TocxTypeInfo ** argTypes;	/* Types of the parameters. */
} TocxFuncInfo;

/*
 * Stores information about an OLE method.
 */

typedef struct TocxMethodInfo {
    struct TocxMethodInfo * next;
    char * name;
    TocxFuncInfo * info;
} TocxMethodInfo;

/*
 *----------------------------------------------------------------------
 * TocxPropertyInfo --
 *
 *	Stores information about a property.
 *
 * 		Group 1 = typeInfoPtr
 * 		Group 2 = funcGet, funcPut, funcPutRef
 *
 *	For any single property, only one of Group 1 or Group 2 is
 *	defined.
 *----------------------------------------------------------------------
 */
typedef struct TocxPropertyInfo {
    struct TocxPropertyInfo * next;
    char * name;		/* Textual name of property */
    MEMBERID memid;		/* Member ID of this property. */
    TocxTypeInfo *typeInfoPtr;  /* Type of this property. */
    TocxFuncInfo *funcGet;	/* Property_get func. */
    TocxFuncInfo *funcPut;	/* Property_put func. */
    TocxFuncInfo *funcPutRef;   /* Property_putref func. */
    int indexed;		/* (Bool) if this is an indexed property,
				 * it must be accessed by the "get" and "set"
				 * widget commands */
} TocxPropertyInfo;

/*
 * Stores information about an OLE event.
 */
typedef struct TocxEventInfo {
    struct TocxEventInfo * next;
    char * name;		/* Textual name of event. */
    FUNCDESC * desc;		/* Describes the parameters of the event. */
} TocxEventInfo;

/*
 * Stores the event bindings (created by the "bind" widget command).
 */
typedef struct TocxEventBinding {
    struct TocxEventBinding * next;
    MEMBERID memid;		/* The memberid of this event */
    char * cmdPrefix;		/* Command prefix. Extra parameters are
				 * appended to this string before it is
				 * evaluated. */
} TocxEventBinding;

#endif /* TOCX_INT_H */

