/*
 * tocxInfo.cpp -- 
 * 
 *      Implements the "tocx_info" command.
 *
 * REMARK:
 *	This command will be rewritten in Tcl. The RegOpenKey(), etc,
 *	primitives will have a Tcl interface.
 *
 * Copyright (c) 1997 Cornell University.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * 
 */

#include "stdafx.h"
#include "tocx.h"

#define MAX_KEY_SIZE 4096

/*
 *--------------------------------------------------------------
 *
 * Tocx_InfoCmd --
 *
 *      Implements the "tocx_info" command. This procedure is invoked
 *      to process the Info option It queries the Registry to find out
 *      what objects are available and information about the objects
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      None
 *
 *--------------------------------------------------------------
 */

int
Tocx_InfoCmd(
    ClientData clientData,      /* Info about the OCX. */
    Tcl_Interp * interp,        /* Current interpreter. */
    int argc,                   /* Number of arguments. */
    char **argv)                /* Argument strings. */
{
    int find_all=0;

    switch (argc) { 
    case 1:
        find_all = 1;
        break;
    case 2:
        find_all = 0;
        break;
    default:
        find_all = -1;
    }

    if (find_all != -1) { 
        int curr = 0;
        int curr2 = 0;
        char subkey[MAX_KEY_SIZE];
        DWORD sizesubkey = MAX_KEY_SIZE;
        char subkey2[MAX_KEY_SIZE];
        DWORD sizesubkey2 = MAX_KEY_SIZE;
        char Data[MAX_KEY_SIZE];
        DWORD cbData = MAX_KEY_SIZE;
        char Data2[MAX_KEY_SIZE];
        DWORD cbData2 = MAX_KEY_SIZE;
        HKEY tempkeyhandle;
        HKEY tempkeyhandle2;
        HKEY tempkeyhandle3;
        int found;
        HKEY clsidkeyhandle;
        Tcl_DString dstring;
        Tcl_DStringInit(&dstring);
        Tcl_DStringStartSublist(&dstring);
        
        found = 0;
        if (RegOpenKeyEx(
                HKEY_CLASSES_ROOT,    // handle of open key 
                "CLSID",    	      // address of name of subkey to open 
                NULL,    	      // reserved 
                KEY_READ|KEY_QUERY_VALUE,    // security access mask 
                &clsidkeyhandle      // address of handle of open key 
                ) != ERROR_SUCCESS) {
            Tcl_AppendResult(interp,"Failed to open CLSID key", (char*)NULL);
            return TCL_ERROR;
        }

        // Querys the registry
        while (RegEnumKeyEx(
                clsidkeyhandle,    // handle of key to enumerate 
                curr,    // index of subkey to enumerate 
                subkey,    // address of buffer for subkey name 
                &sizesubkey,    // address for size of subkey buffer 
                NULL,    // reserved 
                NULL,    // address of buffer for class string 
                NULL,    // address for size of class buffer 
                NULL // address for time key last written to 
                ) == ERROR_SUCCESS) {

            // Opens the subkey's Proid if it exists is the required key

            if (RegOpenKeyEx(
                clsidkeyhandle,    // handle of open key 
                subkey,    // address of name of subkey to open 
                NULL,    // reserved 
                KEY_READ|KEY_QUERY_VALUE,    // security access mask 
                &tempkeyhandle // address of handle of open key 
                ) == ERROR_SUCCESS) { 

                // Opens the ProgID subkey

                if (RegOpenKeyEx(
                    tempkeyhandle,    // handle of open key 
                    "ProgID",    // address of name of subkey to open 
                    NULL,    // reserved 
                    KEY_READ|KEY_QUERY_VALUE,    // security access mask 
                    &tempkeyhandle2 // address of handle of open key 
                    ) == ERROR_SUCCESS) { 

                    // Gets the prog id 
                    if (RegQueryValueEx(
                        tempkeyhandle2,    // handle of key to query 
                        NULL,    // address of name of value to query 
                        NULL,    // reserved 
                        NULL,    // address of buffer for value type 
                        (unsigned char *)Data,    // address of data buffer 
                        &cbData     // address of data buffer size 
                       ) == ERROR_SUCCESS) { 
                        // Checks if progid is the same for tocx info <progid> command
                        if (find_all) { 
                            found = 1;
                            // Prints out the progid of the element
                            Tcl_DStringAppendElement(&dstring,Data);
                        } else { 
                            if (stricmp(Data,argv[1]) == 0) { 
                                // Found the prog id 
                                found = 1;

                                // Now print out whatever we know about it 
                                // Enumerate through the Key values

                                sizesubkey2 = MAX_KEY_SIZE;
                                curr2 = 0;
                                while (RegEnumKeyEx(
                                    tempkeyhandle,    // handle of key to enumerate 
                                    curr2,    // index of subkey to enumerate 
                                    subkey2,    // address of buffer for subkey name 
                                    &sizesubkey2,    // address for size of subkey buffer 
                                    NULL,    // reserved 
                                    NULL,    // address of buffer for class string 
                                    NULL,    // address for size of class buffer 
                                    NULL // address for time key last written to 
                                   ) == ERROR_SUCCESS) { 
                                    // Opens the Key
                                    if (RegOpenKeyEx(
                                        tempkeyhandle,    // handle of open key 
                                        subkey2,    // address of name of subkey to open 
                                        NULL,    // reserved 
                                        KEY_READ|KEY_QUERY_VALUE,    // security access mask 
                                        &tempkeyhandle3 // address of handle of open key 
                                        ) == ERROR_SUCCESS) { 
                                        // Get the key value
                                        if (RegQueryValueEx(
                                            tempkeyhandle3,    // handle of key to query 
                                            NULL,    // address of name of value to query 
                                            NULL,    // reserved 
                                            NULL,    // address of buffer for value type 
                                            (unsigned char *)Data2,    // address of data buffer 
                                            &cbData2     // address of data buffer size 
                                           ) == ERROR_SUCCESS) { 
                                            Tcl_DStringStartSublist(&dstring);
                                            Tcl_DStringAppendElement(&dstring,subkey2);
                                            Tcl_DStringAppendElement(&dstring,Data2);
                                            Tcl_DStringEndSublist(&dstring);
                                            cbData2 = MAX_KEY_SIZE;
                                        }
                                        RegCloseKey(tempkeyhandle3);
                                    }
                                    sizesubkey2 = MAX_KEY_SIZE;
                                    curr2++;
                                }
                            }
                        }
                        cbData = MAX_KEY_SIZE;
                    }
                    RegCloseKey(tempkeyhandle2);
                }
                RegCloseKey(tempkeyhandle);
            }
            curr++;
            sizesubkey = MAX_KEY_SIZE;
        }
    
        RegCloseKey(clsidkeyhandle);

        Tcl_DStringEndSublist(&dstring);

        if (!found) { 
            // Prints error msg
            Tcl_AppendResult(interp,"Failed to find object",(char*)NULL);
            return TCL_ERROR;
        } else { 
            Tcl_SetResult(interp, dstring.string, TCL_VOLATILE);
        } 

        Tcl_DStringFree(&dstring);

        return TCL_OK;
        
    } else {
        // invalid command
        Tcl_AppendResult(interp,"wrong # of args: should be \"",
            argv[0]," ?object_name?\"",(char*)NULL);
        return TCL_ERROR;
    }
}


